<?php
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createSubPackageByParams(array $params)
 * @method editSubPackageByParams(array $params)
 * @method getSubPackageByParams(array $params)
 * @method getSubPackageBindStoreByParams(array $params)
 * @method deleteSubPackageByParams(array $params)
 * @method rebuildSubPackageRelationByParams(array $params)
 * @method cronRebuildSubPackageRelationByParams(array $params)
 * @method getSubPackageByProductIdsByParams(array $params)
 */
class SubPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个子套餐
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @param  string $name 子套餐名称 [ require true ]
     * @param  int $occupyValue 占点数量 [ require true ]
     * @param  mixed $metadata 配置信息 [ require true ]
     * @param  array $extend 额外信息（前端使用） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createSubPackage (int $packageId, string $name, int $occupyValue, $metadata, array $extend) {
        return self::getClass()->createSubPackage([
            "packageId" => $packageId,
            "name" => $name,
            "occupyValue" => $occupyValue,
            "metadata" => $metadata,
            "extend" => $extend,
        ]);
    }

    /**
     * 编辑子套餐
     *
     * @param  int $subPackageId 子套餐ID [ require true ]
     * @param  string $name 子套餐名称 [ require false ]
     * @param  int $occupyValue 占点数量 [ require false ]
     * @param  array $metadata 配置信息 [ require false ]
     * @param  array $extend 额外信息（前端使用） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function editSubPackage (int $subPackageId, string $name = null, int $occupyValue = null, array $metadata = null, array $extend = null) {
        return self::getClass()->editSubPackage([
            "subPackageId" => $subPackageId,
            "name" => $name,
            "occupyValue" => $occupyValue,
            "metadata" => $metadata,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取子套餐详情
     *
     * @param  int $subPackageId 子套餐ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSubPackage (int $subPackageId) {
        return self::getClass()->getSubPackage([
            "subPackageId" => $subPackageId,
        ]);
    }

    /**
     * 获得子套餐可视门店
     *
     * @param  int $subPackageId 子套餐ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSubPackageBindStore (int $subPackageId) {
        return self::getClass()->getSubPackageBindStore([
            "subPackageId" => $subPackageId,
        ]);
    }

    /**
     * 子套餐删除
     *
     * @param  int $subPackageId 删除的子套餐ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSubPackage (int $subPackageId) {
        return self::getClass()->deleteSubPackage([
            "subPackageId" => $subPackageId,
        ]);
    }

    /**
     * 重建关联
     *
     * @param  string $module 所属模块 [ require true ]
     * @param  bool $syncStore 同步门店 [ require false ]
     * @param  bool $syncPhotographyProduct 同步拍摄产品 [ require false ]
     * @param  bool $syncRetailProduct 同步零售产品 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rebuildSubPackageRelation (string $module, bool $syncStore = false, bool $syncPhotographyProduct = false, bool $syncRetailProduct = false) {
        return self::getClass()->rebuildSubPackageRelation([
            "module" => $module,
            "syncStore" => $syncStore,
            "syncPhotographyProduct" => $syncPhotographyProduct,
            "syncRetailProduct" => $syncRetailProduct,
        ]);
    }

    /**
     * 每天凌晨1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronRebuildSubPackageRelation () {
        return self::getClass()->cronRebuildSubPackageRelation();
    }

    /**
     * 获取含某些产品的子套餐
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  array $filterStoreIds 结果集过滤门店ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubPackageByProductIds (array $productIds, array $filterStoreIds = []) {
        return self::getClass()->getSubPackageByProductIds([
            "productIds" => $productIds,
            "filterStoreIds" => $filterStoreIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Package\SubPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Package\SubPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}