<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method deleteGonggeByParams(array $params)
 * @method deleteJxjyByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getListByProductIdByParams(array $params)
 * @method changePriceAreaByParams(array $params)
 * @method unbindPriceAreaByParams(array $params)
 */
class Price {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 此处宫格信息中的配置为增加到的照片张数，如4宫格要增加3张照片，则配置 4: -price
     *
     * @support  int $productId 产品id [ require true ]
     * @support  mixed $price  require false
     * @support  mixed $jxjyPrice 加修加印信息 require false
     * @support  mixed $gonggeInfo 宫格信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 取消宫格
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteGongge (int $id) {
        return self::getClass()->deleteGongge([
            "id" => $id,
        ]);
    }

    /**
     * 取消加修加印
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteJxjy (int $id) {
        return self::getClass()->deleteJxjy([
            "id" => $id,
        ]);
    }

    /**
     * 产品价格详情
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品价格
     *
     * @param  int $id 价格id [ require true ]
     * @support  mixed $price  require false
     * @support  mixed $jxjyPrice 加修加印信息 require false
     * @support  mixed $gonggeInfo 宫格信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品价格
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有价格信息
     *
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByProductId () {
        return self::getClass()->getListByProductId();
    }

    /**
     * 更换价格区
     *
     * @param  int $id 价格id [ require true ]
     * @support  int $new_price_area_id 价格区id [ require true ]
     * @support  int $old_price_area_id 价格区id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePriceArea (int $id) {
        return self::getClass()->changePriceArea([
            "id" => $id,
        ]);
    }

    /**
     * 解绑价格区
     *
     * @param  int $id 价格id [ require true ]
     * @support  int $price_area_id 价格区id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindPriceArea (int $id) {
        return self::getClass()->unbindPriceArea([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Price');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Price');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}