<?php
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPackageByStoreByParams(array $params)
 * @method listPackageByAreaByParams(array $params)
 * @method listPackageByTypeProductByParams(array $params)
 * @method listPackageByTypeProductsByParams(array $params)
 * @method listPackageByTypeProductsByAreaByParams(array $params)
 * @method listPackageByProductsByParams(array $params)
 * @method listPackageByProductsByAreaByParams(array $params)
 * @method getPackageRuleByParams(array $params)
 * @method getPackageRuleByAreaByParams(array $params)
 * @method filterProductInOnlineByParams(array $params)
 * @method filterServiceInOnlineByParams(array $params)
 * @method listStoreIdsBySubPackageIdsByParams(array $params)
 */
class PackageRule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某家门店可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @param  array $filterPackageIds 套餐ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByStore (int $storeId, bool $simple = true, bool $price = false, array $filterPackageIds = []) {
        return self::getClass()->listPackageByStore([
            "storeId" => $storeId,
            "simple" => $simple,
            "price" => $price,
            "filterPackageIds" => $filterPackageIds,
        ]);
    }

    /**
     * 获取某价格区可展示的套餐列表
     *
     * @param  int $areaId 价格区id [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @param  array $filterPackageIds 套餐ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByArea (int $areaId, bool $simple = true, bool $price = false, array $filterPackageIds = []) {
        return self::getClass()->listPackageByArea([
            "areaId" => $areaId,
            "simple" => $simple,
            "price" => $price,
            "filterPackageIds" => $filterPackageIds,
        ]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $id 产品ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByTypeProduct (int $storeId, string $type, int $id, bool $simple = true, bool $price = false) {
        return self::getClass()->listPackageByTypeProduct([
            "storeId" => $storeId,
            "type" => $type,
            "id" => $id,
            "simple" => $simple,
            "price" => $price,
        ]);
    }

    /**
     * 获取某些产品可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  array $ids 多个产品ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByTypeProducts (int $storeId, string $type, array $ids, bool $simple = true, bool $price = false) {
        return self::getClass()->listPackageByTypeProducts([
            "storeId" => $storeId,
            "type" => $type,
            "ids" => $ids,
            "simple" => $simple,
            "price" => $price,
        ]);
    }

    /**
     * 获取某些产品可展示的套餐列表(通过价格区)
     *
     * @param  int $areaId 价格区id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  array $ids 多个产品ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByTypeProductsByArea (int $areaId, string $type, array $ids, bool $simple = true, bool $price = false) {
        return self::getClass()->listPackageByTypeProductsByArea([
            "areaId" => $areaId,
            "type" => $type,
            "ids" => $ids,
            "simple" => $simple,
            "price" => $price,
        ]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  array $productIds 产品ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByProducts (int $storeId, array $productIds, bool $simple = true, bool $price = false) {
        return self::getClass()->listPackageByProducts([
            "storeId" => $storeId,
            "productIds" => $productIds,
            "simple" => $simple,
            "price" => $price,
        ]);
    }

    /**
     * 获取某个产品可展示的套餐列表(通过价格区)
     *
     * @param  int $areaId 价格区id [ require true ]
     * @param  array $productIds 产品ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require false ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByProductsByArea (int $areaId, array $productIds, bool $simple = true, bool $price = false) {
        return self::getClass()->listPackageByProductsByArea([
            "areaId" => $areaId,
            "productIds" => $productIds,
            "simple" => $simple,
            "price" => $price,
        ]);
    }

    /**
     * 获取某个套餐的规则
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $packageId 套餐ID [ require true ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageRule (int $storeId, int $packageId, bool $price = false) {
        return self::getClass()->getPackageRule([
            "storeId" => $storeId,
            "packageId" => $packageId,
            "price" => $price,
        ]);
    }

    /**
     * 获取某个套餐的规则(通过价格区)
     *
     * @param  int $areaId 价格区ID [ require true ]
     * @param  int $packageId 套餐ID [ require true ]
     * @param  bool $price 是否计算价格（目前比较慢） [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageRuleByArea (int $areaId, int $packageId, bool $price = false) {
        return self::getClass()->getPackageRuleByArea([
            "areaId" => $areaId,
            "packageId" => $packageId,
            "price" => $price,
        ]);
    }

    /**
     * 筛选在上架套餐中的产品
     *
     * @param  string $type 类型 [ require false ]
     * @param  array $productIds 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function filterProductInOnline (array $productIds, string $type = 'photography') {
        return self::getClass()->filterProductInOnline([
            "productIds" => $productIds,
            "type" => $type,
        ]);
    }

    /**
     * 筛选在上架套餐中的服务(精确匹配)
     *
     * @param  array $serviceIds 服务ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function filterServiceInOnline (array $serviceIds) {
        return self::getClass()->filterServiceInOnline([
            "serviceIds" => $serviceIds,
        ]);
    }

    /**
     * 通过子套餐ids获取可售卖门店
     *
     * @param  array $subPackageIds 子套餐ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listStoreIdsBySubPackageIds (array $subPackageIds) {
        return self::getClass()->listStoreIdsBySubPackageIds([
            "subPackageIds" => $subPackageIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Package\PackageRule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Package\PackageRule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}