<?php
namespace Mainto\Bridge\Invokes\Product\ProductOccupy;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOccupyNumByParams(array|\Mainto\Bridge\Structs\Product\ProductOccupy\Command\OccupyNumCommand $params)
 * @method clearProductCacheByParams(array $params)
 */
class ProductOccupy {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表占点
     *
     * @var  \Mainto\Bridge\Structs\Product\ProductOccupy\Command\OccupyNumCommand $occupyNumCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOccupyNum (\Mainto\Bridge\Structs\Product\ProductOccupy\Command\OccupyNumCommand $occupyNumCommand) {
        return self::getClass()->getOccupyNum($occupyNumCommand);
    }


    /**
     * clearProductCache
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearProductCache (int $productId) {
        return self::getClass()->clearProductCache([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductOccupy\ProductOccupy');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductOccupy\ProductOccupy');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}