<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method treeByParams(array $params)
 * @method getByParams(array $params)
 * @method getManyByParams(array $params)
 */
class StoreProductTree {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据不同参数获取门店产品树
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $show_level 起始类目等级 [ require false ]
     * @support  string $module module [ require false ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏/false [ require false ]
     * @support  bool $with_deleted 带上已删除的/false [ require false ]
     * @support  bool $with_price 是否带上价格/false [ require false ]
     * @support  array $node_type_list 节点类型array [ require false ]
     * @support  string $node_type 节点类型 [ require false ]
     * @support  int $all_children_by_id 搜索id下面的所有子节点 [ require false ]
     * @support  bool $reject_no_products_category 排除没有产品的类目 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tree () {
        return self::getClass()->tree([
        ]);
    }

    /**
     * 获取门店产品树
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $show_level 起始类目等级/1 [ require false ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  bool $with_price 是否带上产品价格/false [ require false ]
     * @support  bool $reject_no_products_category 排除没有产品的类目 [ require false ]
     * @support  bool $with_services 带上服务 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get () {
        return self::getClass()->get([
        ]);
    }

    /**
     * 获取多个门店的产品树
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  int $show_level 起始类目等级 [ require false ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  bool $with_price 是否带上产品价格/false [ require false ]
     * @support  bool $reject_no_products_category 排除没有产品的类目 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMany () {
        return self::getClass()->getMany([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'StoreProductTree');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'StoreProductTree');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}