<?php
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createSubPackageByParams(array $params)
 * @method editSubPackageByParams(array $params)
 * @method getSubPackageByParams(array $params)
 * @method getSubPackageBindStoreByParams(array $params)
 * @method deleteSubPackageByParams(array $params)
 */
class SubPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个子套餐
     *
     * @param  int $packageId 套餐ID [Original type uint] [ require true ]
     * @param  string $name 子套餐名称 [ require true ]
     * @param  int $occupyValue 占点数量 [Original type uint] [ require true ]
     * @param  array $metadata 配置信息 [ require true ]
     * @support  array $metadata.productInfo 包含的产品 
     * @support  array $metadata.saleAreaPrice 价格配置 
     * @param  array $extend 额外信息（前端使用） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createSubPackage (int $packageId, string $name, int $occupyValue, array $metadata, array $extend) {
        return self::getClass()->createSubPackage([
            "packageId" => $packageId,
            "name" => $name,
            "occupyValue" => $occupyValue,
            "metadata" => $metadata,
            "extend" => $extend,
        ]);
    }

    /**
     * 编辑子套餐
     *
     * @param  int $subPackageId 子套餐ID [Original type uint] [ require true ]
     * @param  string $name 子套餐名称 [ require true ]
     * @param  int $occupyValue 占点数量 [Original type uint] [ require true ]
     * @param  array $metadata 配置信息 [ require true ]
     * @param  array $extend 额外信息（前端使用） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editSubPackage (int $subPackageId, string $name = NULL, int $occupyValue = NULL, array $metadata = NULL, array $extend = NULL) {
        return self::getClass()->editSubPackage([
            "subPackageId" => $subPackageId,
            "name" => $name,
            "occupyValue" => $occupyValue,
            "metadata" => $metadata,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取子套餐详情
     *
     * @param  int $subPackageId 子套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSubPackage (int $subPackageId) {
        return self::getClass()->getSubPackage([
            "subPackageId" => $subPackageId,
        ]);
    }

    /**
     * 获得子套餐可视门店
     *
     * @param  int $subPackageId 子套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSubPackageBindStore (int $subPackageId) {
        return self::getClass()->getSubPackageBindStore([
            "subPackageId" => $subPackageId,
        ]);
    }

    /**
     * 子套餐删除
     *
     * @param  int $subPackageId 删除的子套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSubPackage (int $subPackageId) {
        return self::getClass()->deleteSubPackage([
            "subPackageId" => $subPackageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Package\SubPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Package\SubPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}