<?php
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listStorePackageByParams(array $params)
 * @method listProductPackageByParams(array $params)
 * @method getPackageRuleByParams(array $params)
 */
class PackageRule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某家门店可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listStorePackage (int $storeId) {
        return self::getClass()->listStorePackage([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listProductPackage (int $storeId, string $type, int $id) {
        return self::getClass()->listProductPackage([
            "storeId" => $storeId,
            "type" => $type,
            "id" => $id,
        ]);
    }

    /**
     * 获取某个套餐的规则
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  int $packageId 套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageRule (int $storeId, int $packageId) {
        return self::getClass()->getPackageRule([
            "storeId" => $storeId,
            "packageId" => $packageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Package\PackageRule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Package\PackageRule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}