<?php
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPackageByParams(array $params)
 * @method getPackageByParams(array $params)
 * @method createPackageByParams(array $params)
 * @method updatePackageByParams(array $params)
 * @method updatePackageExtendByParams(array $params)
 * @method updatePackageTimeByParams(array $params)
 * @method clearPackageTimeByParams(array $params)
 * @method upPackageByParams(array $params)
 * @method downPackageByParams(array $params)
 * @method getPackageBindStoreByParams(array $params)
 */
class Package {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 套餐列表
     *
     * @param  string $module 所属模块 [ require true ]
     * @param  string $name 套餐名称 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listPackage (int $page = 0, string $module = '', string $name = '', string $status = '') {
        return self::getClass()->listPackage([
            "page" => $page,
            "module" => $module,
            "name" => $name,
            "status" => $status,
        ]);
    }

    /**
     * 获取套餐详情
     *
     * @param  int $id 套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackage (int $id) {
        return self::getClass()->getPackage([
            "id" => $id,
        ]);
    }

    /**
     * 创建一个套餐
     *
     * @param  string $module 所属模块 [ require true ]
     * @param  string $name 套餐名称 [ require true ]
     * @param  string $engName 英文套餐名称 [ require true ]
     * @param  array $extend 额外信息（前端使用） [ require true ]
     * @param  array $metadata 基础信息（后端使用） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createPackage (string $module, string $name, string $engName, array $extend, array $metadata) {
        return self::getClass()->createPackage([
            "module" => $module,
            "name" => $name,
            "engName" => $engName,
            "extend" => $extend,
            "metadata" => $metadata,
        ]);
    }

    /**
     * 更新一个套餐
     *
     * @param  int $id 更新的套餐ID [Original type uint] [ require true ]
     * @param  string $module 所属模块 [ require true ]
     * @param  string $name 套餐名称 [ require true ]
     * @param  string $engName 英文套餐名称 [ require true ]
     * @param  array $extend 额外信息（前端使用） [ require true ]
     * @param  array $metadata 基础信息（后端使用） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updatePackage (int $id, string $module = NULL, string $name = NULL, string $engName = NULL, array $extend = NULL, array $metadata = NULL) {
        return self::getClass()->updatePackage([
            "id" => $id,
            "module" => $module,
            "name" => $name,
            "engName" => $engName,
            "extend" => $extend,
            "metadata" => $metadata,
        ]);
    }

    /**
     * 更新一个套餐 extend 信息
     *
     * @param  int $id 更新的套餐ID [Original type uint] [ require true ]
     * @param  array $extend 额外信息（前端使用） [ require true ]
     * @param  bool $merge 使用合并模式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updatePackageExtend (int $id, array $extend, bool $merge = false) {
        return self::getClass()->updatePackageExtend([
            "id" => $id,
            "extend" => $extend,
            "merge" => $merge,
        ]);
    }

    /**
     * 更新一个套餐上下架时间
     *
     * @param  int $id 更新的套餐ID [Original type uint] [ require true ]
     * @param  string $startTime 上架时间 [ require true ]
     * @param  string $endTime 下架时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updatePackageTime (int $id, string $startTime = '', string $endTime = '') {
        return self::getClass()->updatePackageTime([
            "id" => $id,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 清空一个套餐上下架时间
     *
     * @param  int $id 更新的套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function clearPackageTime (int $id) {
        return self::getClass()->clearPackageTime([
            "id" => $id,
        ]);
    }

    /**
     * 套餐上架
     *
     * @param  int $id 更新的套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upPackage (int $id) {
        return self::getClass()->upPackage([
            "id" => $id,
        ]);
    }

    /**
     * 套餐下架
     *
     * @param  int $id 更新的套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downPackage (int $id) {
        return self::getClass()->downPackage([
            "id" => $id,
        ]);
    }

    /**
     * 获得套餐可视门店
     *
     * @param  int $id 套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageBindStore (int $id) {
        return self::getClass()->getPackageBindStore([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Package\Package');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Package\Package');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}