<?php
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPackageByStoreByParams(array $params)
 * @method listPackageByTypeProductByParams(array $params)
 * @method listPackageByProductsByParams(array $params)
 * @method getPackageRuleByParams(array $params)
 * @method filterProductInOnlineByParams(array $params)
 */
class PackageRule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某家门店可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByStore (int $storeId, bool $simple = true) {
        return self::getClass()->listPackageByStore([
            "storeId" => $storeId,
            "simple" => $simple,
        ]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $id 产品ID [ require true ]
     * @param  bool $simple 简易的结果返回 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByTypeProduct (int $storeId, string $type, int $id, bool $simple = true) {
        return self::getClass()->listPackageByTypeProduct([
            "storeId" => $storeId,
            "type" => $type,
            "id" => $id,
            "simple" => $simple,
        ]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  array $productIds 产品ID [Original type array&lt;int&gt;] [ require true ]
     * @param  bool $simple 简易的结果返回 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listPackageByProducts (int $storeId, array $productIds, bool $simple = true) {
        return self::getClass()->listPackageByProducts([
            "storeId" => $storeId,
            "productIds" => $productIds,
            "simple" => $simple,
        ]);
    }

    /**
     * 获取某个套餐的规则
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  int $packageId 套餐ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageRule (int $storeId, int $packageId) {
        return self::getClass()->getPackageRule([
            "storeId" => $storeId,
            "packageId" => $packageId,
        ]);
    }

    /**
     * 筛选在上架套餐中的产品
     *
     * @param  array $productIds 产品ID [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function filterProductInOnline (array $productIds) {
        return self::getClass()->filterProductInOnline([
            "productIds" => $productIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Package\PackageRule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Package\PackageRule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}