<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getListByProductIdByParams(array $params)
 * @method changePriceAreaByParams(array $params)
 * @method unbindPriceAreaByParams(array $params)
 */
class Price {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 此处宫格信息中的配置为增加到的照片张数，如4宫格要增加3张照片，则配置 4: -price
     *
     * @support  int $productId 产品id [ require true ]
     * @support  string $price.mode 价格类型 
     * @support  float $price.original 原价 [Original type unsignedDouble] [ require true ]
     * @support  float $price.now 现价 [Original type unsignedDouble] [ require true ]
     * @support  float $price.addPeople 加人加价 [Original type unsignedDouble] [ require true ]
     * @support  array $jxjyPrice 加修加印信息 
     * @support  float $jxjyPrice.original 加修加印-原价 [Original type unsignedDouble] 
     * @support  float $jxjyPrice.now 加修加印-现价 [Original type unsignedDouble] 
     * @support  float $jxjyPrice.addPeople 加修加印-加人加价 [Original type unsignedDouble] 
     * @support  int $jxjyPrice.minPeople 加修加印-最小人数 [Original type uint] 
     * @support  float $jxjyPrice.maxPeople 加修加印-最大人数 [Original type unsignedDouble] 
     * @support  array $gonggeInfo 宫格信息 
     * @support  array $gonggeInfo.discount 宫格信息-优惠信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品价格详情
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品价格
     *
     * @param  int $id 价格id [ require true ]
     * @support  string $price.mode 价格类型 
     * @support  float $price.original 原价 [Original type unsignedDouble] 
     * @support  float $price.now 现价 [Original type unsignedDouble] 
     * @support  float $price.addPeople 加人加价 [Original type unsignedDouble] 
     * @support  array $jxjyPrice 加修加印信息 
     * @support  float $jxjyPrice.original 加修加印-原价 [Original type unsignedDouble] 
     * @support  float $jxjyPrice.now 加修加印-现价 [Original type unsignedDouble] 
     * @support  float $jxjyPrice.addPeople 加修加印-加人加价 [Original type unsignedDouble] 
     * @support  int $jxjyPrice.minPeople 加修加印-最小人数 [Original type uint] 
     * @support  float $jxjyPrice.maxPeople 加修加印-最大人数 [Original type unsignedDouble] 
     * @support  array $gonggeInfo 宫格信息 
     * @support  array $gonggeInfo.discount 宫格信息-优惠信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品价格
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有价格信息
     *
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByProductId () {
        return self::getClass()->getListByProductId();
    }

    /**
     * 更换价格区
     *
     * @param  int $id 价格id [ require true ]
     * @support  int $new_price_area_id 价格区id [ require true ]
     * @support  int $old_price_area_id 价格区id 
     * @throws  \Exception
     * @return  array
     */
    public static function changePriceArea (int $id) {
        return self::getClass()->changePriceArea([
            "id" => $id,
        ]);
    }

    /**
     * 解绑价格区
     *
     * @param  int $id 价格id [ require true ]
     * @support  int $price_area_id 价格区id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindPriceArea (int $id) {
        return self::getClass()->unbindPriceArea([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Price');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Price');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}