<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method bindStoresByParams(array $params)
 * @method unbindStoresByParams(array $params)
 * @method detailByStoreIdByParams(array $params)
 */
class PriceArea {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 价格区列表
     *
     * @support  array $ids 价格区ids 
     * @support  string $module 模块 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 创建价格区
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  string $module 模块 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 价格区详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新价格区
     *
     * @support  int $id id [ require true ]
     * @support  string $name name [ require true ]
     * @support  string $module 模块 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除价格区
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 价格区绑定门店
     *
     * @support  int $id id [ require true ]
     * @support  array $store_ids 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindStores () {
        return self::getClass()->bindStores();
    }

    /**
     * 价格区解绑门店
     *
     * @support  int $id id [ require true ]
     * @support  array $store_ids 门店ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindStores () {
        return self::getClass()->unbindStores();
    }

    /**
     * 获取门店下的价格区
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByStoreId () {
        return self::getClass()->detailByStoreId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'PriceArea');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'PriceArea');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}