<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreDiscountByParams(array $params)
 * @method getStoreServiceDiscountByParams(array $params)
 * @method addProductDiscountRuleByParams(array $params)
 * @method productDiscountDetailByParams(array $params)
 * @method getDiscountByIdsByParams(array $params)
 * @method editProductShowInfoByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method deleteDiscountByParams(array $params)
 * @method addServiceDiscountRuleByParams(array $params)
 * @method editServiceShowInfoByParams(array $params)
 * @method getServiceDiscountListByParams(array $params)
 * @method deleteServiceDiscountByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @param  bool $add_hour 是否包含一个小时内将会开始的活动 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreDiscount (int $store_id, bool $add_hour = true) {
        return self::getClass()->getStoreDiscount([
            "store_id" => $store_id,
            "add_hour" => $add_hour,
        ]);
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @param  bool $add_hour 是否包含一个小时内将会开始的活动 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreServiceDiscount (int $store_id, bool $add_hour = true) {
        return self::getClass()->getStoreServiceDiscount([
            "store_id" => $store_id,
            "add_hour" => $add_hour,
        ]);
    }

    /**
     * 新建产品计算折扣规则
     *
     * @support  string $name 折扣名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] 
     * @support  string $group 分组（是否可与优惠券共用） [ require true ]
     * @support  int $sc_id 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @support  string $discount_type 折扣类型 [ require true ]
     * @support  string $share_type 共享类型 [ require true ]
     * @support  string $payload_check 折扣规则校验 [ require true ]
     * @support  array $payload_arr 折扣适用产品 
     * @support  int $mini_kind_num 最小产品种类 [Original type uint] 
     * @support  int $mini_pay_num 最小产品数量 [Original type uint] 
     * @support  float $mini_buy_price 最小购买金额 [Original type double] 
     * @support  string $payload_type 折扣适配类型 
     * @support  bool $pick 是否打包优惠 [ require true ]
     * @support  float $discount_value 折扣计算值 [Original type double] 
     * @support  float $start_discount_value 起始折扣值 [Original type double] 
     * @support  bool $is_limit 是否为限时折扣 
     * @support  array $show_info 前端显示信息 
     * @support  string $start_time 折扣开始时间 
     * @support  string $end_time 折扣结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function addProductDiscountRule () {
        return self::getClass()->addProductDiscountRule();
    }

    /**
     * 获取产品折扣详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productDiscountDetail (int $id) {
        return self::getClass()->productDiscountDetail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取产品优惠
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDiscountByIds (array $ids) {
        return self::getClass()->getDiscountByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 修改产品折扣信息
     *
     * @param  int $discount_id 编辑的ID [Original type uint] [ require true ]
     * @param  array $show_info 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editProductShowInfo (int $discount_id, array $show_info = []) {
        return self::getClass()->editProductShowInfo([
            "discount_id" => $discount_id,
            "show_info" => $show_info,
        ]);
    }

    /**
     * O1 分页方式, 使用limit和fromId进行分页
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $page_size 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDiscountList (int $page = 1, int $page_size = 20) {
        return self::getClass()->getProductDiscountList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 删除产品折扣
     *
     * @param  int $discount_id 折扣id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDiscount (int $discount_id) {
        return self::getClass()->deleteDiscount([
            "discount_id" => $discount_id,
        ]);
    }

    /**
     * 新建服务计算折扣规则
     *
     * @support  string $module 模块 [ require true ]
     * @support  string $name 折扣名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] 
     * @support  int $sc_id 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @support  string $discount_type 折扣类型 [ require true ]
     * @support  int $product_id 服务绑定产品信息 
     * @support  string $payload_check 折扣规则校验 [ require true ]
     * @support  array $payload_arr 折扣适用产品 
     * @support  int $mini_kind_num 最小产品种类 [Original type uint] 
     * @support  int $mini_pay_num 最小产品数量 [Original type uint] 
     * @support  int $mini_buy_price 最小购买金额 [Original type uint] 
     * @support  string $payload_type 折扣适配类型 
     * @support  bool $pick 是否打包优惠 [ require true ]
     * @support  float $discount_value 折扣计算值 [Original type double] 
     * @support  float $start_discount_value 起始折扣值 [Original type double] 
     * @support  bool $is_limit 是否为限时折扣 
     * @support  string $start_time 折扣开始时间 
     * @support  string $end_time 折扣结束时间 
     * @support  string $group 分组（是否可与优惠券共用） [ require true ]
     * @support  array $show_info 前端显示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceDiscountRule () {
        return self::getClass()->addServiceDiscountRule();
    }

    /**
     * 修改服务折扣信息
     *
     * @param  int $discount_id 编辑的ID [Original type uint] [ require true ]
     * @param  array $show_info 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editServiceShowInfo (int $discount_id, array $show_info = []) {
        return self::getClass()->editServiceShowInfo([
            "discount_id" => $discount_id,
            "show_info" => $show_info,
        ]);
    }

    /**
     * 服务折扣列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $page_size 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceDiscountList (int $page = 1, int $page_size = 20) {
        return self::getClass()->getServiceDiscountList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 删除服务折扣
     *
     * @param  int $discount_id 折扣id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteServiceDiscount (int $discount_id) {
        return self::getClass()->deleteServiceDiscount([
            "discount_id" => $discount_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}