<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method editByParams(array $params)
 * @method deleteByParams(array $params)
 * @method removeByParams(array $params)
 * @method getListByProductIdByParams(array $params)
 * @method changePriceAreaByParams(array $params)
 * @method unbindPriceAreaByParams(array $params)
 */
class ProductServicePrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品价格
     *
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] [ require true ]
     * @support  string $price_mode 价格类型 
     * @support  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品价格详情
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品价格
     *
     * @param  int $id id [ require true ]
     * @support  float $original_price 原价 [Original type double] 
     * @support  float $price 现价 [Original type double] 
     * @support  float $add_people_price 加人加价 [Original type double] 
     * @support  string $price_mode 价格类型 
     * @support  int $product_id 产品id 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 编辑产品价格
     *
     * @param  int $id 价格ID [ require true ]
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] [ require true ]
     * @support  string $price_mode 价格类型 
     * @throws  \Exception
     * @return  array
     */
    public static function edit (int $id) {
        return self::getClass()->edit([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品价格
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品价格
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有价格信息
     *
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByProductId () {
        return self::getClass()->getListByProductId();
    }

    /**
     * 更换价格区
     *
     * @param  int $id 价格id [ require true ]
     * @support  int $new_price_area_id 价格区id [ require true ]
     * @support  int $old_price_area_id 价格区id 
     * @throws  \Exception
     * @return  array
     */
    public static function changePriceArea (int $id) {
        return self::getClass()->changePriceArea([
            "id" => $id,
        ]);
    }

    /**
     * 解绑价格区
     *
     * @param  int $id 价格id [ require true ]
     * @support  int $price_area_id 价格区id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindPriceArea (int $id) {
        return self::getClass()->unbindPriceArea([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductServicePrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductServicePrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}