<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailInStoreByParams(array $params)
 * @method updateByParams(array $params)
 * @method setCHiddenByParams(array $params)
 * @method getDetailByIdsByParams(array $params)
 * @method deleteByParams(array $params)
 * @method removeByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method upByRetailIdByParams(array $params)
 * @method offByRetailIdByParams(array $params)
 * @method getStoreProductsByParams(array $params)
 * @method getPriceInAreaByParams(array $params)
 * @method setDeadlineByParams(array $params)
 * @method blacklistStoreIdsByParams(array $params)
 * @method blacklistsByParams(array $params)
 * @method addStoreToBlacklistByParams(array $params)
 * @method getServiceByIdsByParams(array $params)
 * @method getNameByParams(array $params)
 * @method getFullNameByParams(array $params)
 * @method getServiceIdsByTypeOrProductIdsByParams(array $params)
 * @method getServiceFullNameByParams(array $params)
 * @method getProductAndServiceByStoreIdsByParams(array $params)
 * @method canSendImageToCloudServiceByIdsByParams(array $params)
 * @method getProductTreeByIdsByParams(array $params)
 * @method getProductTreeByModuleByParams(array $params)
 * @method getPhotographicNumByParams(array $params)
 * @method getStoreProductTreeByParams(array $params)
 * @method getProductsByStoreIdCategoryIdsByParams(array $params)
 * @method getProductsByStoreIdCategoryIdByParams(array $params)
 * @method getStoreAllProductByParams(array $params)
 * @method haveSameProductsAndServicesStoreByParams(array $params)
 * @method haveSameProductProductStoreByParams(array $params)
 * @method getProductsInStoreByParams(array $params)
 * @method getProductInStoreByParams(array $params)
 * @method serviceGroupsByParams(array $params)
 * @method serviceLabelsByParams(array $params)
 * @method addServiceGroupByParams(array $params)
 * @method editServiceGroupByParams(array $params)
 * @method addServiceLabelByParams(array $params)
 * @method getProductIdsByRetailProductIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  string $fill_name 全称(模糊查询) 
     * @support  array $module 所属模块 
     * @support  int $category_id 分类ID 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  bool $c_hidden 预约端是否隐藏 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 产品列表分页
     *
     * @support  string $name 名称(模糊查询) 
     * @support  string $fill_name 全称(模糊查询) 
     * @support  array $module 所属模块 
     * @support  int $category_id 分类ID 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  bool $c_hidden 预约端是否隐藏 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 新增产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $module 模块 [ require true ]
     * @support  int $category_id 类目 ID 
     * @support  string $eng_name 英文名称 
     * @support  string $main_img 产品主图 [ require true ]
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小适配人数 
     * @support  int $max_people_num 最大适配人数 
     * @support  int $photographic_num 可上传拍摄照片数量 
     * @support  int $occupy_value 占点设置 
     * @support  int $sort 排序 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  string $type 服务类型 
     * @support  string $deadline 预约截止时间 
     * @support  string $comment 描述 
     * @support  int $retail_product_id 关联的零售id 
     * @support  array $extend 产品展示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 门店产品详情(带价格)
     *
     * @param  int $id id [ require true ]
     * @support  int $store_id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailInStore (int $id) {
        return self::getClass()->detailInStore([
            "id" => $id,
        ]);
    }

    /**
     * 编辑产品
     *
     * @param  int $id id [ require true ]
     * @support  string $name 产品名称 
     * @support  string $module 模块 
     * @support  int $category_id P ID 
     * @support  string $status 状态 
     * @support  string $eng_name 英文名称 
     * @support  string $main_img 产品主图 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小适配人数 
     * @support  int $max_people_num 最大适配人数 
     * @support  int $photographic_num 可上传拍摄照片数量 
     * @support  int $occupy_value 占点设置 
     * @support  int $sort 排序 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  string $type 服务类型 
     * @support  string $deadline 预约截止时间 
     * @support  string $comment 描述 
     * @support  int $retail_product_id 关联的零售id 
     * @support  array $extend 产品展示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 设置预约端显示/隐藏
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @support  bool $c_hidden 是否预约端隐藏 
     * @throws  \Exception
     * @return  array
     */
    public static function setCHidden (int $id) {
        return self::getClass()->setCHidden([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取产品基础信息详情
     *
     * @param  array $ids 产品id集 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByIds (array $ids) {
        return self::getClass()->getDetailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 上架一个产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function up (int $id) {
        return self::getClass()->up([
            "id" => $id,
        ]);
    }

    /**
     * 下架一个产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function off (int $id) {
        return self::getClass()->off([
            "id" => $id,
        ]);
    }

    /**
     * 上架一个零售产品关联的拍摄产品
     *
     * @param  int $id 零售产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function upByRetailId (int $id) {
        return self::getClass()->upByRetailId([
            "id" => $id,
        ]);
    }

    /**
     * 下架一个零售产品关联的拍摄产品
     *
     * @param  int $id 零售产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function offByRetailId (int $id) {
        return self::getClass()->offByRetailId([
            "id" => $id,
        ]);
    }

    /**
     * 获取门店下面的产品信息
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  int $show_level 起始类目等级 
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProducts () {
        return self::getClass()->getStoreProducts();
    }

    /**
     * 获取产品在某个价格区下面的价格
     *
     * @param  int $id 产品ID [ require true ]
     * @support  int $price_area_id 价格区id 
     * @throws  \Exception
     * @return  array
     */
    public static function getPriceInArea (int $id) {
        return self::getClass()->getPriceInArea([
            "id" => $id,
        ]);
    }

    /**
     * 设置预约截止时间
     *
     * @param  int $id 产品ID [ require true ]
     * @support  string $deadline 预约截止时间 
     * @throws  \Exception
     * @return  array
     */
    public static function setDeadline (int $id) {
        return self::getClass()->setDeadline([
            "id" => $id,
        ]);
    }

    /**
     * 产品禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function blacklistStoreIds (int $id) {
        return self::getClass()->blacklistStoreIds([
            "id" => $id,
        ]);
    }

    /**
     * 产品禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function blacklists (int $id) {
        return self::getClass()->blacklists([
            "id" => $id,
        ]);
    }

    /**
     * 产品禁用门店, 返回更新后的禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @support  array $store_ids 门店ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStoreToBlacklist (int $id) {
        return self::getClass()->addStoreToBlacklist([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取服务详情
     *
     * @param  array $ids 服务ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceByIds (array $ids) {
        return self::getClass()->getServiceByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取名称
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getName (array $ids) {
        return self::getClass()->getName([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取全称
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFullName (array $ids) {
        return self::getClass()->getFullName([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取服务ids
     *
     * @support  string $type 服务type [ require true ]
     * @support  array $product_ids 服务ids 
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceIdsByTypeOrProductIds () {
        return self::getClass()->getServiceIdsByTypeOrProductIds();
    }

    /**
     * 批量获取服务全称
     *
     * @param  array $ids 服务ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceFullName (array $ids) {
        return self::getClass()->getServiceFullName([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取多个门店产品服务信息
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  bool $hidden_no_price 是否隐藏没价格产品 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductAndServiceByStoreIds () {
        return self::getClass()->getProductAndServiceByStoreIds();
    }

    /**
     * 获取云端传图类服务，有人用吗？有用的找我
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function canSendImageToCloudServiceByIds (array $ids) {
        return self::getClass()->canSendImageToCloudServiceByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据产品ids获取产品树
     *
     * @support  array $product_ids 产品ids [ require true ]
     * @support  string $status 产品状态（默认上架） 
     * @support  int $show_level 起始类目等级 
     * @support  bool $c_hidden 是否包含预约端隐藏 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductTreeByIds () {
        return self::getClass()->getProductTreeByIds();
    }

    /**
     * 获取根类目产品树
     *
     * @support  array $module 所属模块数组 
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否包含预约端隐藏 
     * @support  int $show_level 起始类目等级 
     * @support  bool $with_no_product_category 带上没有产品的类目 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductTreeByModule () {
        return self::getClass()->getProductTreeByModule();
    }

    /**
     * 获取可上传摄影数量
     * @deprecated
     *
     * @param  int $pid 产品ID [ require true ]
     * @param  int $sid 升级服务ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getPhotographicNum (int $pid, int $sid = 0) {
        return self::getClass()->getPhotographicNum([
            "pid" => $pid,
            "sid" => $sid,
        ]);
    }

    /**
     * 获取门店产品树
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $show_level 起始类目等级 
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  bool $with_price 是否带上产品价格 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreProductTree () {
        return self::getClass()->getStoreProductTree();
    }

    /**
     * 获取门店某些类目下所有产品
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  array $category_ids 类目ids [ require true ]
     * @support  string $module 所属产品线 
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  bool $with_price 是否带上产品价格 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsByStoreIdCategoryIds () {
        return self::getClass()->getProductsByStoreIdCategoryIds();
    }

    /**
     * 获取门店某个类目下所有产品
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $category_id 类目ID [ require true ]
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  bool $with_price 是否带上产品价格 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsByStoreIdCategoryId () {
        return self::getClass()->getProductsByStoreIdCategoryId();
    }

    /**
     * 获取门店所有产品
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $status 产品状态（默认上架） 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  bool $with_price 是否带上产品价格 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreAllProduct () {
        return self::getClass()->getStoreAllProduct();
    }

    /**
     * 筛选出同有某些产品和升级服务的一些门店
     *
     * @support  array $store_ids 门店ID [Original type array&lt;uint&gt;] 
     * @support  array $products 产品和升级服务 
     * @throws  \Exception
     * @return  array
     */
    public static function haveSameProductsAndServicesStore () {
        return self::getClass()->haveSameProductsAndServicesStore();
    }

    /**
     * 筛选出同有某个产品的一些门店
     *
     * @support  array $store_ids 门店ID [Original type array&lt;uint&gt;] 
     * @support  array $product_ids 产品ID数组 [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  array
     */
    public static function haveSameProductProductStore () {
        return self::getClass()->haveSameProductProductStore();
    }

    /**
     * 获取门店多个产品详情
     *
     * @support  array $product_ids 产品ID数组 [Original type array&lt;uint&gt;] [ require true ]
     * @support  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInStore () {
        return self::getClass()->getProductsInStore();
    }

    /**
     * 查询门店的一个产品（含在该门店的价格）
     *
     * @support  int $product_id 产品ID [ require true ]
     * @support  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInStore () {
        return self::getClass()->getProductInStore();
    }

    /**
     * 批量获取全部服务组
     * @deprecated
     *
     * @param  array $ids 服务组ID数组（不传则返回全部） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function serviceGroups (array $ids = []) {
        return self::getClass()->serviceGroups([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取全部服务项
     * @deprecated
     *
     * @param  array $ids 服务项ID数组（不传则返回全部） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function serviceLabels (array $ids = []) {
        return self::getClass()->serviceLabels([
            "ids" => $ids,
        ]);
    }

    /**
     * 创建一个服务组
     * @deprecated
     *
     * @support  string $name 服务组名称 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  bool $multiple 是否支持多选 [ require true ]
     * @support  bool $is_required 是否必选 [ require true ]
     * @support  array $extend 扩展字段 
     * @support  string $comment 描述 
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceGroup () {
        return self::getClass()->addServiceGroup();
    }

    /**
     * 编辑升级服务组
     * @deprecated
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  bool $multiple 是否支持多选 
     * @support  bool $is_required 是否必填 
     * @support  array $extend 扩展字段 
     * @support  string $comment 描述 
     * @throws  \Exception
     * @return  array
     */
    public static function editServiceGroup () {
        return self::getClass()->editServiceGroup();
    }

    /**
     * 创建一个服务项（存在同名则返回同名的那个）
     * @deprecated
     *
     * @param  string $name 服务label名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceLabel (string $name) {
        return self::getClass()->addServiceLabel([
            "name" => $name,
        ]);
    }

    /**
     * 根据零售产品批量获取产品ids
     *
     * @param  array $retail_product_ids 零售产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductIdsByRetailProductIds (array $retail_product_ids = []) {
        return self::getClass()->getProductIdsByRetailProductIds([
            "retail_product_ids" => $retail_product_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}