<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 */
class ProductServiceGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量获取全部服务组
     *
     * @support  array $ids 服务项ID数组（不传则返回全部） 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 创建一个服务组
     *
     * @support  string $name 服务组名称 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  bool $multiple 是否支持多选 [ require true ]
     * @support  bool $is_required 是否必选 [ require true ]
     * @support  array $extend 扩展字段 
     * @support  string $comment 描述 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 服务组详情
     *
     * @param  int $id 服务id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 编辑升级服务组
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  bool $multiple 是否支持多选 
     * @support  bool $is_required 是否必填 
     * @support  array $extend 扩展字段 
     * @support  string $comment 描述 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductServiceGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductServiceGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}