<?php
namespace Mainto\Bridge\Invokes\Product\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method linkedSkuByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建物料编码
     *
     * @param  int $material_coding 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $material_coding) {
        return self::getClass()->create([
            "material_coding" => $material_coding,
        ]);
    }

    /**
     * 关联sku
     *
     * @param  int $id 别名id [Original type uint] [ require true ]
     * @param  array $sku_ids 产品sku_ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function linkedSku (int $id, array $sku_ids = []) {
        return self::getClass()->linkedSku([
            "id" => $id,
            "sku_ids" => $sku_ids,
        ]);
    }

    /**
     * 获取物料分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $page_size 页内条数 [ require true ]
     * @param  int $material_coding 物料编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $material_coding = 0, int $page = 1, int $page_size = 20) {
        return self::getClass()->list([
            "material_coding" => $material_coding,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取物料编号详情
     *
     * @param  int $id 物料编号id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除物料编码
     *
     * @param  int $id 物料编码id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Retail\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Retail\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}