<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateExtendByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method bindParentByParams(array $params)
 * @method getChildByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method setCHiddenNestedByParams(array $params)
 * @method changeNodesSortByParams(array $params)
 * @method changeProductNodesSortByParams(array $params)
 * @method getClothesInStoreByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @support  int $parentId 类目父级ID 
     * @support  int $sort 排序 
     * @support  bool $multiple 是否支持多选 [ require true ]
     * @support  array $extend 产品类目展示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新类目
     *
     * @support  int $id 类目ID [ require true ]
     * @support  string $name 类目名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @support  int $sort 排序 
     * @support  bool $multiple 是否支持多选 
     * @support  int $parentId 父类ID 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 更新产品类目展示信息
     *
     * @param  int $id 类目ID [Original type uint] [ require true ]
     * @param  array $extend 展示信息array [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateExtend (int $id, array $extend) {
        return self::getClass()->updateExtend([
            "id" => $id,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取类目详情
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  string $name 类目名称(模糊查询) [ require true ]
     * @param  string $full_name 类目全名称(模糊查询) [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  string $module 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (array $ids = [], int $page = 1, int $pageSize = 20, string $name = '', string $full_name = '', int $parentId = 0, bool $showDeleted = false, string $module = 'himo') {
        return self::getClass()->list([
            "ids" => $ids,
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "full_name" => $full_name,
            "parentId" => $parentId,
            "showDeleted" => $showDeleted,
            "module" => $module,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  string $name 类目名称(模糊查询) [ require true ]
     * @param  string $full_name 类目全名称(模糊查询) [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  string $module 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (array $ids = [], string $name = '', string $full_name = '', int $parentId = 0, bool $showDeleted = false, string $module = 'himo') {
        return self::getClass()->all([
            "ids" => $ids,
            "name" => $name,
            "full_name" => $full_name,
            "parentId" => $parentId,
            "showDeleted" => $showDeleted,
            "module" => $module,
        ]);
    }

    /**
     * 更改状态
     *
     * @param  int $id 分类ID [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 绑定上级类目
     *
     * @param  int $id 类目ID [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindParent (int $id, int $parentId) {
        return self::getClass()->bindParent([
            "id" => $id,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 扁平获取下级子类
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChild (int $id) {
        return self::getClass()->getChild([
            "id" => $id,
        ]);
    }

    /**
     * 获取树状类目
     *
     * @param  int $show_level 起始类目等级 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryTree (int $show_level = 0) {
        return self::getClass()->getCategoryTree([
            "show_level" => $show_level,
        ]);
    }

    /**
     * 开启/关闭类目下所有产品的预约端显示（不包括服务）
     *
     * @support  int $id 类目ID [ require true ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCHiddenNested () {
        return self::getClass()->setCHiddenNested();
    }

    /**
     * 改变类目下的下一级sort大于等于指定值的子节点的排序
     *
     * @support  int $id 类目ID [ require true ]
     * @support  int $num 数值 
     * @support  int $sort 大于的sort值 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeNodesSort () {
        return self::getClass()->changeNodesSort();
    }

    /**
     * 改变类目下的下一级sort大于指定值的产品的排序
     *
     * @support  int $id 类目ID [ require true ]
     * @support  int $num 数值 
     * @support  int $sort 大于的sort值 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeProductNodesSort () {
        return self::getClass()->changeProductNodesSort();
    }

    /**
     * 获取对应门店类目下面的服装信息
     *
     * @param  int $id id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getClothesInStore (int $id) {
        return self::getClass()->getClothesInStore([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}