<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class ProductService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建服务
     *
     * @support  int $product_id 产品ID [Original type uint] [ require true ]
     * @support  int $service_group_id 服务组ID [Original type uint] [ require true ]
     * @support  int $service_label_id Label ID [Original type uint] [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  int $mini_people_num 服务最小匹配人数 [Original type uint] 
     * @support  int $max_people_num 服务最大匹配人数 [Original type uint] 
     * @support  int $photographic_num 摄影上传数量 [Original type uint] 
     * @support  int $occupy_value 占点设置 [Original type uint] 
     * @support  bool $c_hidden 预约端隐藏 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  string $desc 描述 
     * @support  string $main_img 主图 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新服务
     *
     * @param  int $id 服务id [Original type uint] [ require true ]
     * @support  int $product_id 产品ID [Original type uint] [ require true ]
     * @support  int $service_group_id 服务组ID [Original type uint] [ require true ]
     * @support  int $service_label_id Label ID [Original type uint] [ require true ]
     * @support  string $eng_name 英文名称 [ require true ]
     * @support  int $mini_people_num 服务最小匹配人数 [Original type uint] [ require true ]
     * @support  int $max_people_num 服务最大匹配人数 [Original type uint] [ require true ]
     * @support  int $photographic_num 摄影上传数量 [Original type uint] [ require true ]
     * @support  int $occupy_value 占点设置 [Original type uint] [ require true ]
     * @support  bool $c_hidden 预约端隐藏 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  string $desc 描述 
     * @support  string $main_img 主图 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除服务
     *
     * @param  int $id 服务id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}