<?php
namespace Mainto\Bridge\Invokes\Product\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method batchRemoveByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method treeByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  int $parent_id 类目名称 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新类目
     *
     * @param  int $id 类目ID [ require true ]
     * @param  string $name 类目名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $name) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 批量更新类目
     *
     * @param  array $data 类目数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 获取类目详情
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 批量删除
     *
     * @param  array $ids 类目IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchRemove (array $ids) {
        return self::getClass()->batchRemove([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $page_size 页内条数 [ require true ]
     * @param  bool $show_deleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $page_size = 20, bool $show_deleted = false) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
            "show_deleted" => $show_deleted,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  bool $show_deleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (bool $show_deleted = false) {
        return self::getClass()->all([
            "show_deleted" => $show_deleted,
        ]);
    }

    /**
     * 类目树
     *
     * @support  bool $with_products 是否带产品信息 
     * @support  bool $with_deleted 带上软删除的数据 
     * @support  int $parent_id 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function tree () {
        return self::getClass()->tree();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Retail\ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Retail\ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}