<?php
namespace Mainto\Bridge\Invokes\Product\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method getDetailByIdsByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method getRetailSkuIdByErpSkuIdByParams(array $params)
 * @method getErpSkuIdByRetailSkuIdByParams(array $params)
 * @method syncErpMaterialsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 多个产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByIds (array $ids) {
        return self::getClass()->getDetailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $page_size 页内条数 [ require true ]
     * @param  string $name 名称(模糊查询) [ require true ]
     * @param  int $category_id 分类ID [ require true ]
     * @param  bool $show_deleted 是否显示已删除信息 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $page_size = 20, int $category_id = 0, string $name = '', string $status = '', bool $show_deleted = false) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
            "category_id" => $category_id,
            "name" => $name,
            "status" => $status,
            "show_deleted" => $show_deleted,
        ]);
    }

    /**
     * 获取产品列表
     *
     * @param  string $name 名称(模糊查询) [ require true ]
     * @param  int $category_id 分类ID [ require true ]
     * @param  bool $show_deleted 是否显示已删除信息 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $category_id = 0, string $name = '', string $status = '', bool $show_deleted = false) {
        return self::getClass()->all([
            "category_id" => $category_id,
            "name" => $name,
            "status" => $status,
            "show_deleted" => $show_deleted,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id) {
        return self::getClass()->up([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function off (int $id) {
        return self::getClass()->off([
            "id" => $id,
        ]);
    }

    /**
     * 通过erp物料的skuId换取对应零售物料的skuid
     *
     * @param  int $erpSkuId erp物料的skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetailSkuIdByErpSkuId (int $erpSkuId) {
        return self::getClass()->getRetailSkuIdByErpSkuId([
            "erpSkuId" => $erpSkuId,
        ]);
    }

    /**
     * 通过对应零售物料的skuid换取erp物料的skuId
     *
     * @param  int $skuId bms物料的skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getErpSkuIdByRetailSkuId (int $skuId) {
        return self::getClass()->getErpSkuIdByRetailSkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 同步erp物料
     *
     * @param  string $name 物料产品名称 [ require true ]
     * @param  string $mainImg 物料图片 [ require true ]
     * @param  array $skuBasic 物料基础sku项目 [ require true ]
     * @param  array $sku 物料sku值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncErpMaterials (string $name, string $mainImg, array $skuBasic, array $sku) {
        return self::getClass()->syncErpMaterials([
            "name" => $name,
            "mainImg" => $mainImg,
            "skuBasic" => $skuBasic,
            "sku" => $sku,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Retail\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Retail\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}