<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductPriceByParams(array $params)
 * @method getServicePriceByParams(array $params)
 */
class ProductCalc {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 计算产品价格并返回计算详情
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @param  array $detail 购买信息的数组, 示例代表产品1,2人合照买3个产品,服务1,2人购买2个服务 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPrice (int $store_id, array $detail) {
        return self::getClass()->getProductPrice([
            "store_id" => $store_id,
            "detail" => $detail,
        ]);
    }

    /**
     * 计算服务价格并返回计算详情
     *
     * @param  int $store_id 门店ID [Original type uint] [ require true ]
     * @param  int $product_id 产品ID [Original type uint] [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  array $services 购买信息的数组, 示例代表服务1,2人合照买3个服务 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServicePrice (int $store_id, string $module, int $product_id, array $services) {
        return self::getClass()->getServicePrice([
            "store_id" => $store_id,
            "module" => $module,
            "product_id" => $product_id,
            "services" => $services,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductCalc');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductCalc');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}