<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method serviceLabelMigrateByParams(array $params)
 * @method dataMigrateByParams(array $params)
 * @method priceMigrateByParams(array $params)
 * @method storeMigrateByParams(array $params)
 */
class DataMigrate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 服务label预迁移
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceLabelMigrate () {
        return self::getClass()->serviceLabelMigrate();
    }

    /**
     * 数据迁移填充
     *
     * @throws  \Exception
     * @return  array
     */
    public static function dataMigrate () {
        return self::getClass()->dataMigrate();
    }

    /**
     * 价格迁移
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function priceMigrate () {
        return self::getClass()->priceMigrate();
    }

    /**
     * 价格门店关联迁移
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeMigrate () {
        return self::getClass()->storeMigrate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'DataMigrate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'DataMigrate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}