<?php
namespace Mainto\Bridge\Invokes\Product\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method listByParams(array $params)
 * @method disableProductByParams(array $params)
 * @method enableProductByParams(array $params)
 * @method getProductIdByParams(array $params)
 * @method getCloudProductIdByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $retouch_require 修片要求 [ require true ]
     * @support  array $simple_images 样片 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取产品详情
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取产品信息
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $page_size 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $page_size = 20) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 禁用产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableProduct (int $id) {
        return self::getClass()->disableProduct([
            "id" => $id,
        ]);
    }

    /**
     * 启用产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableProduct (int $id) {
        return self::getClass()->enableProduct([
            "id" => $id,
        ]);
    }

    /**
     * 根据云端产品ID获取产品ID
     *
     * @param  int $cloud_product_id 云端产品ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getProductId (int $cloud_product_id) {
        return self::getClass()->getProductId([
            "cloud_product_id" => $cloud_product_id,
        ]);
    }

    /**
     * 根据产品ID获取云端产品ID
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProductId (int $id) {
        return self::getClass()->getCloudProductId([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Cloud\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Cloud\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}