<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method bindParentByParams(array $params)
 * @method getChildByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @support  int $sort 排序 
     * @support  bool $multiple 是否支持多选 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新类目
     *
     * @support  int $id 类目ID [ require true ]
     * @support  string $name 类目名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @support  int $sort 排序 
     * @support  bool $multiple 是否支持多选 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取类目详情
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取分页列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  string $name 类目名称(模糊查询) [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 20, string $name = '', int $parentId = 0, bool $showDeleted = false) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "parentId" => $parentId,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 获取列表
     *
     * @param  string $name 类目名称(模糊查询) [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $name = '', int $parentId = 0, bool $showDeleted = false) {
        return self::getClass()->all([
            "name" => $name,
            "parentId" => $parentId,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 更改状态
     *
     * @param  int $id 分类ID [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 绑定上级类目
     *
     * @param  int $id 类目ID [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindParent (int $id, int $parentId) {
        return self::getClass()->bindParent([
            "id" => $id,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 扁平获取下级子类
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChild (int $id) {
        return self::getClass()->getChild([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}