<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method removeByParams(array $params)
 * @method getListByProductIdByParams(array $params)
 */
class ProductPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] [ require true ]
     * @support  string $price_mode 价格类型 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑产品价格
     *
     * @param  int $id 价格ID [ require true ]
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] [ require true ]
     * @support  string $price_mode 价格类型 
     * @throws  \Exception
     * @return  array
     */
    public static function edit (int $id) {
        return self::getClass()->edit([
            "id" => $id,
        ]);
    }

    /**
     * remove
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有价格信息
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByProductId (int $product_id) {
        return self::getClass()->getListByProductId([
            "product_id" => $product_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}