<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method getDetailByIdsByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method styleGroupsByParams(array $params)
 * @method styleLabelsByParams(array $params)
 * @method serviceGroupsByParams(array $params)
 * @method serviceLabelsByParams(array $params)
 * @method addStyleGroupByParams(array $params)
 * @method addStyleLabelByParams(array $params)
 * @method addServiceGroupByParams(array $params)
 * @method addServiceLabelByParams(array $params)
 * @method bindProductToStoresByParams(array $params)
 * @method bindServiceToStoresByParams(array $params)
 * @method getProductInStoreByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 所属类目ID [ require true ]
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小适配人数 
     * @support  int $max_people_num 最大适配人数 
     * @support  int $sort 排序 
     * @support  array $styles 产品风格数组 
     * @support  array $services 产品升级服务数组 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑产品
     *
     * @support  int $id 产品ID [ require true ]
     * @support  string $name 产品名称 
     * @support  int $category_id 所属类目ID 
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $mini_people_num 最小适配人数 
     * @support  int $max_people_num 最大适配人数 
     * @support  int $sort 排序 
     * @support  array $styles 产品风格数组 
     * @support  array $services 产品升级服务数组 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取产品基础信息详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取产品基础信息详情
     *
     * @param  array $ids 产品id集 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByIds (array $ids) {
        return self::getClass()->getDetailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 类目名称(模糊查询) 
     * @support  int $category_id 分类ID 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 上架一个产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id) {
        return self::getClass()->up([
            "id" => $id,
        ]);
    }

    /**
     * 下架一个产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function off (int $id) {
        return self::getClass()->off([
            "id" => $id,
        ]);
    }

    /**
     * 全部给风格组
     *
     * @param  array $ids 风格组ID数组（不传则返回全部） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function styleGroups (array $ids = []) {
        return self::getClass()->styleGroups([
            "ids" => $ids,
        ]);
    }

    /**
     * 全部风格项
     *
     * @param  array $ids 风格项ID数组（不传则返回全部） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function styleLabels (array $ids = []) {
        return self::getClass()->styleLabels([
            "ids" => $ids,
        ]);
    }

    /**
     * 全部服务组
     *
     * @param  array $ids 服务组ID数组（不传则返回全部） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function serviceGroups (array $ids = []) {
        return self::getClass()->serviceGroups([
            "ids" => $ids,
        ]);
    }

    /**
     * 全部服务项
     *
     * @param  array $ids 服务项ID数组（不传则返回全部） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function serviceLabels (array $ids = []) {
        return self::getClass()->serviceLabels([
            "ids" => $ids,
        ]);
    }

    /**
     * 创建一个风格组（存在同名则返回同名的那个）
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addStyleGroup (string $name) {
        return self::getClass()->addStyleGroup([
            "name" => $name,
        ]);
    }

    /**
     * 创建一个风格项（存在同名则返回同名的那个）
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addStyleLabel (string $name) {
        return self::getClass()->addStyleLabel([
            "name" => $name,
        ]);
    }

    /**
     * TODO 服务组接口考虑支持完整的CURD
     *
     * @support  string $name  [ require true ]
     * @support  bool $multiple  [ require true ]
     * @support  bool $is_required  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceGroup () {
        return self::getClass()->addServiceGroup();
    }

    /**
     * 创建一个服务项（存在同名则返回同名的那个）
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceLabel (string $name) {
        return self::getClass()->addServiceLabel([
            "name" => $name,
        ]);
    }

    /**
     * 绑定一个产品到门店
     *
     * @param  int $product_id  [ require true ]
     * @param  array $store_ids  [ require true ]
     * @param  int $price_id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductToStores (int $product_id, array $store_ids, int $price_id) {
        return self::getClass()->bindProductToStores([
            "product_id" => $product_id,
            "store_ids" => $store_ids,
            "price_id" => $price_id,
        ]);
    }

    /**
     * 绑定一个升级服务到门店
     *
     * @param  int $service_id  [ require true ]
     * @param  array $store_ids  [ require true ]
     * @param  int $price_id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindServiceToStores (int $service_id, array $store_ids, int $price_id) {
        return self::getClass()->bindServiceToStores([
            "service_id" => $service_id,
            "store_ids" => $store_ids,
            "price_id" => $price_id,
        ]);
    }

    /**
     * 查询门店的一个产品（含在该门店的价格）
     *
     * @param  int $product_id  [ require true ]
     * @param  int $store_id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInStore (int $product_id, int $store_id) {
        return self::getClass()->getProductInStore([
            "product_id" => $product_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}