<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method removeByParams(array $params)
 * @method getListByServiceIdByParams(array $params)
 */
class ProductServicePrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  int $service_id 服务ID [ require true ]
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] [ require true ]
     * @support  string $price_mode 价格类型 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑服务价格
     *
     * @param  int $id 价格ID [ require true ]
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] [ require true ]
     * @support  string $price_mode 价格类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit (int $id) {
        return self::getClass()->edit([
            "id" => $id,
        ]);
    }

    /**
     * remove
     *
     * @param  int $id 价格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取服务所有价格信息
     *
     * @param  int $service_id 服务ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByServiceId (int $service_id) {
        return self::getClass()->getListByServiceId([
            "service_id" => $service_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductServicePrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductServicePrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}