<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method getStoreByServiceIdByParams(array $params)
 * @method getProductByServiceIdByParams(array $params)
 * @method getProductByStoreServiceIdByParams(array $params)
 * @method getStoreByServicePriceByParams(array $params)
 * @method getServiceByStoreIdByParams(array $params)
 * @method getServiceByProductIdByParams(array $params)
 */
class StoreService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建门店-服务关联
     *
     * @support  array $storeIds 门店ids [ require true ]
     * @support  int $servicePriceId 升级服务价格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 门店服务关联详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除门店服务关联信息
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取拥有当前服务的所有门店
     *
     * @param  int $serviceId 升级服务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreByServiceId (int $serviceId) {
        return self::getClass()->getStoreByServiceId([
            "serviceId" => $serviceId,
        ]);
    }

    /**
     * 获取拥有当前服务的所有产品
     *
     * @param  int $serviceId 升级服务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductByServiceId (int $serviceId) {
        return self::getClass()->getProductByServiceId([
            "serviceId" => $serviceId,
        ]);
    }

    /**
     * 获取当前门店内拥有当前服务的所有产品
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $serviceId 服务id [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductByStoreServiceId (int $storeId, int $serviceId, int $page = 1, int $pageSize = 20) {
        return self::getClass()->getProductByStoreServiceId([
            "storeId" => $storeId,
            "serviceId" => $serviceId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取当前服务价格绑定的所有门店
     *
     * @param  int $servicePriceId 升级服务价格id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreByServicePrice (int $servicePriceId) {
        return self::getClass()->getStoreByServicePrice([
            "servicePriceId" => $servicePriceId,
        ]);
    }

    /**
     * 获取当前门店所有服务
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceByStoreId (int $storeId) {
        return self::getClass()->getServiceByStoreId([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取当前产品的服务信息
     *
     * @param  int $productId 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServiceByProductId (int $productId) {
        return self::getClass()->getServiceByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'StoreService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'StoreService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}