<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addStoreServiceDiscountByParams(array $params)
 * @method editServiceShowInfoByParams(array $params)
 * @method getServiceDiscountListByParams(array $params)
 * @method deleteServiceDiscountByParams(array $params)
 */
class ServiceDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建服务计算折扣规则
     *
     * @support  string $name 折扣名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] 
     * @support  int $scId 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @support  string $discountType 折扣类型 [ require true ]
     * @support  int $productId 服务绑定产品信息 
     * @support  string $payloadCheck 折扣规则校验 [ require true ]
     * @support  array $payloadArr 折扣适用产品 
     * @support  int $miniKindNum 最小产品种类 [Original type uint] 
     * @support  int $miniPayNum 最小产品数量 [Original type uint] 
     * @support  int $miniBuyPrice 最小购买金额 [Original type uint] 
     * @support  string $payloadType 折扣适配类型 
     * @support  float $discountValue 折扣计算值 [Original type double] 
     * @support  int $isLimit 是否为限时折扣 [Original type uint] 
     * @support  string $startTime 折扣开始时间 
     * @support  string $endTime 折扣结束时间 
     * @support  array $payload 折扣计算载荷 
     * @support  array $showInfo 前端显示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function addStoreServiceDiscount () {
        return self::getClass()->addStoreServiceDiscount();
    }

    /**
     * 修改服务折扣信息
     *
     * @param  int $discountId 编辑的ID [Original type uint] [ require true ]
     * @param  array $showInfo 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editServiceShowInfo (int $discountId, array $showInfo = []) {
        return self::getClass()->editServiceShowInfo([
            "discountId" => $discountId,
            "showInfo" => $showInfo,
        ]);
    }

    /**
     * O1 分页方式, 使用limit和fromId进行分页
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceDiscountList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getServiceDiscountList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除服务折扣
     *
     * @param  int $discountId 折扣id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteServiceDiscount (int $discountId) {
        return self::getClass()->deleteServiceDiscount([
            "discountId" => $discountId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ServiceDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ServiceDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}