<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreDiscountByParams(array $params)
 * @method addStoreProductDiscountByParams(array $params)
 * @method editProductShowInfoByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method deleteDiscountByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  bool $addHour 是否包含一个小时内将会开始的活动 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreDiscount (int $storeId, bool $addHour = true) {
        return self::getClass()->getStoreDiscount([
            "storeId" => $storeId,
            "addHour" => $addHour,
        ]);
    }

    /**
     * 新建产品计算折扣规则
     *
     * @support  string $name 折扣名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] 
     * @support  int $scId 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @support  string $discountType 折扣类型 [ require true ]
     * @support  string $shareType 共享类型 [ require true ]
     * @support  string $payloadCheck 折扣规则校验 [ require true ]
     * @support  array $payloadArr 折扣适用产品 
     * @support  int $miniKindNum 最小产品种类 [Original type uint] 
     * @support  int $miniPayNum 最小产品数量 [Original type uint] 
     * @support  int $miniBuyPrice 最小购买金额 [Original type uint] 
     * @support  string $payloadType 折扣适配类型 
     * @support  float $discountValue 折扣计算值 [Original type double] 
     * @support  int $isLimit 是否为限时折扣 [Original type uint] 
     * @support  string $startTime 折扣开始时间 
     * @support  string $endTime 折扣结束时间 
     * @support  array $payload 折扣计算载荷 
     * @support  array $showInfo 前端显示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function addStoreProductDiscount () {
        return self::getClass()->addStoreProductDiscount();
    }

    /**
     * 修改产品折扣信息
     *
     * @param  int $discountId 编辑的ID [Original type uint] [ require true ]
     * @param  array $showInfo 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editProductShowInfo (int $discountId, array $showInfo = []) {
        return self::getClass()->editProductShowInfo([
            "discountId" => $discountId,
            "showInfo" => $showInfo,
        ]);
    }

    /**
     * O1 分页方式, 使用limit和fromId进行分页
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDiscountList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getProductDiscountList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除产品折扣
     *
     * @param  int $discountId 折扣id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteDiscount (int $discountId) {
        return self::getClass()->deleteDiscount([
            "discountId" => $discountId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}