<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailFullByParams(array $params)
 * @method updateByParams(array $params)
 * @method removeByParams(array $params)
 * @method upByParams(array $params)
 * @method downByParams(array $params)
 * @method listByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品信息包含产品基础信息和产品风格信息，产品风格信息分为产品风格组和风格详情
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 产品所属类目id [ require true ]
     * @support  string $mainImg 主图 
     * @support  string $description 描述 
     * @support  string $engName 英文名称 
     * @support  int $ miniPeopleNum 最小人数 
     * @support  int $maxPeopleNum 最大人数 
     * @support  int $sort 排序 
     * @support  array $entend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 预约端产品详情
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  int $productId 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailFull (int $storeId, int $productId) {
        return self::getClass()->detailFull([
            "storeId" => $storeId,
            "productId" => $productId,
        ]);
    }

    /**
     * 更新产品
     *
     * @support  int $id id [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 产品所属类目id [ require true ]
     * @support  string $mainImg 主图 
     * @support  string $description 描述 
     * @support  string $engName 英文名称 
     * @support  int $ miniPeopleNum 最小人数 
     * @support  int $maxPeopleNum 最大人数 
     * @support  int $sort 排序 
     * @support  array $entend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除产品
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id) {
        return self::getClass()->up([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function down (int $id) {
        return self::getClass()->down([
            "id" => $id,
        ]);
    }

    /**
     * 产品列表
     *
     * @param  int $id 产品id [ require true ]
     * @param  int $categoryId 类目id [ require true ]
     * @param  string $name 产品名称(模糊查询) [ require true ]
     * @param  string $status 产品状态 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $id = NULL, int $page = 1, int $pageSize = 20, int $categoryId = NULL, string $name = NULL, string $status = NULL) {
        return self::getClass()->list([
            "id" => $id,
            "page" => $page,
            "pageSize" => $pageSize,
            "categoryId" => $categoryId,
            "name" => $name,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}