<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createGroupByParams(array $params)
 * @method groupDetailByParams(array $params)
 * @method updateGroupByParams(array $params)
 * @method removeGroupByParams(array $params)
 * @method listByParams(array $params)
 * @method createItemByParams(array $params)
 * @method itemDetailByParams(array $params)
 * @method updateItemByParams(array $params)
 * @method removeItemByParams(array $params)
 * @method getItemByGroupIdByParams(array $params)
 */
class ProductService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建升级服务组
     *
     * @support  string $name 升级服务组名称 [ require true ]
     * @support  int $parentId 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function createGroup () {
        return self::getClass()->createGroup();
    }

    /**
     * 升级服务组详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function groupDetail (int $id) {
        return self::getClass()->groupDetail([
            "id" => $id,
        ]);
    }

    /**
     * 更新升级服务组
     *
     * @support  int $id id [ require true ]
     * @support  string $name 升级服务组名称 [ require true ]
     * @support  int $parentId 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function updateGroup () {
        return self::getClass()->updateGroup();
    }

    /**
     * 删除升级服务组
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeGroup (int $id) {
        return self::getClass()->removeGroup([
            "id" => $id,
        ]);
    }

    /**
     * 升级服务组列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 20) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 创建升级服务
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  int $groupId 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function createItem () {
        return self::getClass()->createItem();
    }

    /**
     * 升级服务详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemDetail (int $id) {
        return self::getClass()->itemDetail([
            "id" => $id,
        ]);
    }

    /**
     * 更新升级服务
     *
     * @support  int $id id [ require true ]
     * @support  string $name 类目名称 [ require true ]
     * @support  int $groupId 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function updateItem () {
        return self::getClass()->updateItem();
    }

    /**
     * 删除升级服务
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeItem (int $id) {
        return self::getClass()->removeItem([
            "id" => $id,
        ]);
    }

    /**
     * 获取当前升级服务组下所有升级服务
     *
     * @param  int $groupId 服务组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemByGroupId (int $groupId) {
        return self::getClass()->getItemByGroupId([
            "groupId" => $groupId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}