<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method removeByParams(array $params)
 * @method getPriceByProductIdByParams(array $params)
 * @method getProductPriceStoreByParams(array $params)
 */
class ProductPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品价格
     *
     * @support  int $productId 产品id [ require true ]
     * @support  float $originalPrice 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $addPeoplePrice 加人加价 [Original type double] 
     * @support  string $priceMode 价格类型 
     * @support  string $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品价格详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品价格
     *
     * @support  int $id id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  float $originalPrice 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $addPeoplePrice 加人加价 [Original type double] 
     * @support  string $priceMode 价格类型 
     * @support  string $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除产品价格
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有价格
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPriceByProductId (int $productId) {
        return self::getClass()->getPriceByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品价格绑定门店
     *
     * @param  int $priceId 产品价格id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPriceStore (int $priceId) {
        return self::getClass()->getProductPriceStore([
            "priceId" => $priceId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}