<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method getStoreByPriceIdByParams(array $params)
 * @method getStoreByProductIdByParams(array $params)
 * @method getProductByStoreIdByParams(array $params)
 */
class StoreProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建门店-产品关联/绑定价格到多家门店
     *
     * @support  int $productPriceId 价格ID [Original type uint] [ require true ]
     * @support  array $storeIds 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 门店产品关联详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 一旦某家门店没有某个产品, 该产品将在此家门店不可售卖
     *
     * @param  int $priceId 价格ID [Original type uint] [ require true ]
     * @param  array $storeIds 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $priceId, array $storeIds) {
        return self::getClass()->remove([
            "priceId" => $priceId,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取绑定当前产品价格的所有门店
     *
     * @param  int $priceId 价格ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByPriceId (int $priceId) {
        return self::getClass()->getStoreByPriceId([
            "priceId" => $priceId,
        ]);
    }

    /**
     * 获取拥有当前产品的所有门店
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByProductId (int $productId) {
        return self::getClass()->getStoreByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取当前门店拥有的所有产品
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductByStoreId (int $storeId) {
        return self::getClass()->getProductByStoreId([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'StoreProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'StoreProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}