<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStyleGroupByParams(array $params)
 * @method styleGroupDetailByParams(array $params)
 * @method removeStyleGroupByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method getProductStyleByParams(array $params)
 */
class ProductStyle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建风格组
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @throws  \Exception
     * @return  array
     */
    public static function createStyleGroup () {
        return self::getClass()->createStyleGroup();
    }

    /**
     * 获取风格组详情
     *
     * @param  int $id 风格组ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function styleGroupDetail (int $id) {
        return self::getClass()->styleGroupDetail([
            "id" => $id,
        ]);
    }

    /**
     * 删除风格组组
     *
     * @param  int $id 风格组ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStyleGroup (int $id) {
        return self::getClass()->removeStyleGroup([
            "id" => $id,
        ]);
    }

    /**
     * 创建风格
     *
     * @support  int $productId 产品ID [ require true ]
     * @support  int $styleGroupId 服务分组ID [ require true ]
     * @support  int $styleLabelId Label ID 
     * @support  string $name 名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取风格信息
     *
     * @param  int $id 风格ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除风格
     *
     * @param  int $id 风格ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有风格
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductStyle (int $productId) {
        return self::getClass()->getProductStyle([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductStyle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductStyle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}