<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getStoreProductServicePriceByParams(array $params)
 */
class ProductStoreService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新门店产品服务关联信息
     *
     * @support  array $storeIds 门店数组 [Original type array&lt;uint&gt;] [ require true ]
     * @support  int $productId 门店ID [ require true ]
     * @support  int $serviceId 服务ID [ require true ]
     * @support  float $originalPrice 原始价格 [Original type double] [ require true ]
     * @support  float $price 产品现价 [Original type double] [ require true ]
     * @support  float $addPeoplePrice 加人加价 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取门店产品的多个服务价格
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $productId 产品ID [ require true ]
     * @param  array $serviceIds 服务ID数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductServicePrice (int $storeId, int $productId, array $serviceIds) {
        return self::getClass()->getStoreProductServicePrice([
            "storeId" => $storeId,
            "productId" => $productId,
            "serviceIds" => $serviceIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductStoreService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductStoreService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}