<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method insertOrUpdateByParams(array $params)
 * @method getStoreProductDetailByParams(array $params)
 * @method filterMustHaveProductsStoresByParams(array $params)
 * @method storeHaveProductByParams(array $params)
 * @method getProductAllStoreByParams(array $params)
 * @method getStoreAllProductByParams(array $params)
 * @method getAllPriceByProductIdByParams(array $params)
 */
class ProductStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新门店产品的门店和价格
     *
     * @support  array $storeIds 门店数组 [Original type array&lt;uint&gt;] [ require true ]
     * @support  int $productId 门店ID [ require true ]
     * @support  float $originalPrice 原始价格 [Original type double] [ require true ]
     * @support  float $price 产品现价 [Original type double] [ require true ]
     * @support  float $addPeoplePrice 加人加价 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function insertOrUpdate () {
        return self::getClass()->insertOrUpdate();
    }

    /**
     * 获取产品详情(包含附属信息)
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductDetail (int $storeId, int $productId) {
        return self::getClass()->getStoreProductDetail([
            "storeId" => $storeId,
            "productId" => $productId,
        ]);
    }

    /**
     * 将返回拥有的门店ID
     *
     * @param  array $storeIds 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  array $products 产品ID数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function filterMustHaveProductsStores (array $storeIds = [], array $products = []) {
        return self::getClass()->filterMustHaveProductsStores([
            "storeIds" => $storeIds,
            "products" => $products,
        ]);
    }

    /**
     * 将返回拥有的产品ID
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  array $products 产品ID数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeHaveProduct (int $storeId, array $products = []) {
        return self::getClass()->storeHaveProduct([
            "storeId" => $storeId,
            "products" => $products,
        ]);
    }

    /**
     * 获取产品所在的所有门店
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductAllStore (int $productId) {
        return self::getClass()->getProductAllStore([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取门店所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreAllProduct (int $storeId) {
        return self::getClass()->getStoreAllProduct([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取产品所有价格
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllPriceByProductId (int $productId) {
        return self::getClass()->getAllPriceByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}