<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createServiceGroupByParams(array $params)
 * @method groupDetailByParams(array $params)
 * @method removeGroupByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method getProductServiceByParams(array $params)
 */
class ProductService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建服务分组
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @support  bool $multiple 是否支持多选 
     * @support  bool $isRequired 是否必选 
     * @throws  \Exception
     * @return  array
     */
    public static function createServiceGroup () {
        return self::getClass()->createServiceGroup();
    }

    /**
     * 服务分组详情
     *
     * @param  int $id ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function groupDetail (int $id) {
        return self::getClass()->groupDetail([
            "id" => $id,
        ]);
    }

    /**
     * 删除分组
     *
     * @param  int $id ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeGroup (int $id) {
        return self::getClass()->removeGroup([
            "id" => $id,
        ]);
    }

    /**
     * 创建升级服务
     *
     * @support  int $productId 产品ID [ require true ]
     * @support  int $serviceGroupId 服务分组ID [ require true ]
     * @support  int $serviceLabelId Label ID 
     * @support  string $name 名称 [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 删除服务项
     *
     * @param  int $id 服务ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品所有服务
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductService (int $productId) {
        return self::getClass()->getProductService([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}