<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method updateStatusByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $categoryId 所属类目ID [ require true ]
     * @support  string $engName 英文名称 
     * @support  string $fullName 全称 
     * @support  int $miniPeopleNum 最小适配人数 
     * @support  int $maxPeopleNum 最大适配人数 
     * @support  int $sort 排序 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑产品
     *
     * @param  int $id 产品ID [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  string $engName 英文名称 [ require true ]
     * @param  string $fullName 全称 [ require true ]
     * @param  int $miniPeopleNum 最小适配人数 [ require true ]
     * @param  int $maxPeopleNum 最大适配人数 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $name = NULL, string $engName = NULL, string $fullName = NULL, int $miniPeopleNum = 1, int $maxPeopleNum = 1, int $sort = 0) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "engName" => $engName,
            "fullName" => $fullName,
            "miniPeopleNum" => $miniPeopleNum,
            "maxPeopleNum" => $maxPeopleNum,
            "sort" => $sort,
        ]);
    }

    /**
     * 获取产品基础信息详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @param  int $id 产品ID [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  string $name 类目名称(模糊查询) [ require true ]
     * @param  int $categoryId 分类ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $id = NULL, int $page = 1, int $pageSize = 20, int $categoryId = NULL, string $name = NULL, string $status = NULL, bool $showDeleted = false) {
        return self::getClass()->list([
            "id" => $id,
            "page" => $page,
            "pageSize" => $pageSize,
            "categoryId" => $categoryId,
            "name" => $name,
            "status" => $status,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 获取产品分页列表
     *
     * @param  int $id 产品ID [ require true ]
     * @param  string $name 类目名称(模糊查询) [ require true ]
     * @param  int $categoryId 分类ID [ require true ]
     * @param  bool $showDeleted 是否显示已删除信息 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $id = NULL, int $categoryId = NULL, string $name = NULL, string $status = NULL, bool $showDeleted = false) {
        return self::getClass()->all([
            "id" => $id,
            "categoryId" => $categoryId,
            "name" => $name,
            "status" => $status,
            "showDeleted" => $showDeleted,
        ]);
    }

    /**
     * 更新产品状态
     *
     * @param  int $id 产品ID [ require true ]
     * @param  string $status 状态值 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}