<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method getChildByParams(array $params)
 * @method getAllChildByParams(array $params)
 * @method getParentByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品类目
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  int $parentId 父级id 
     * @support  string $engName 英文名称 
     * @support  int $sort 排序 
     * @support  string $host 图片资源站域名 
     * @support  array $serviceItemSet 详情页-服务项说明 
     * @support  array $samples 详情页样片 
     * @support  array $explanation 产品选型弹层-产品说明 
     * @support  array $imgForService 服务体验展示 
     * @support  array $extend 其他配图 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品类目详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品类目
     *
     * @support  int $id id [ require true ]
     * @support  string $name 类目名称 
     * @support  int $parentId 父级id 
     * @support  string $engName 英文名称 
     * @support  int $sort 排序 
     * @support  string $host 图片资源站域名 
     * @support  array $serviceItemSet 详情页-服务项说明 
     * @support  array $samples 详情页样片 
     * @support  array $explanation 产品选型弹层-产品说明 
     * @support  array $imgForService 服务体验展示 
     * @support  array $extend 其他配图 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除产品类目
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 类目列表
     *
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @param  string $name 类目名称(支持模糊搜索) [ require true ]
     * @param  int $parentId 类目父类id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 20, string $name = NULL, int $parentId = NULL) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 扁平获取类目子级
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChild (int $id) {
        return self::getClass()->getChild([
            "id" => $id,
        ]);
    }

    /**
     * 树状获取所有类目
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllChild (int $id) {
        return self::getClass()->getAllChild([
            "id" => $id,
        ]);
    }

    /**
     * 获取类目父级
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getParent (int $id) {
        return self::getClass()->getParent([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}