<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreDiscountByParams(array $params)
 * @method addStoreDiscountByParams(array $params)
 * @method addProductNodeDiscountByParams(array $params)
 * @method editDiscountByParams(array $params)
 * @method getDiscountListByParams(array $params)
 * @method deleteDiscountByParams(array $params)
 * @method restoreDiscountByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  bool $addHour 是否包含一个小时内将会开始的活动 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreDiscount (int $storeId, bool $addHour = true) {
        return self::getClass()->getStoreDiscount([
            "storeId" => $storeId,
            "addHour" => $addHour,
        ]);
    }

    /**
     * 如果创建的是单品折扣, 请使用新建单品折扣规则接口
     *
     * @param  string $name 折扣名称 [ require true ]
     * @param  string $group 折扣分组 [ require true ]
     * @param  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] [ require true ]
     * @param  int $scId 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @param  string $discountType 折扣类型 [ require true ]
     * @param  string $shareType 共享类型 [ require true ]
     * @param  string $startTime 折扣开始时间 [ require true ]
     * @param  string $endTime 折扣结束时间 [ require true ]
     * @param  array $payload 折扣计算载荷 [ require true ]
     * @param  array $showInfo 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addStoreDiscount (string $name, string $group, int $sort, int $scId, string $discountType, string $shareType, string $startTime, string $endTime, array $payload, array $showInfo = []) {
        return self::getClass()->addStoreDiscount([
            "name" => $name,
            "group" => $group,
            "sort" => $sort,
            "scId" => $scId,
            "discountType" => $discountType,
            "shareType" => $shareType,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "payload" => $payload,
            "showInfo" => $showInfo,
        ]);
    }

    /**
     * 新建单品折扣规则
     *
     * @param  string $name 折扣名称 [ require true ]
     * @param  string $group 折扣分组 [ require true ]
     * @param  int $nodeId 节点名称 [Original type uint] [ require true ]
     * @param  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] [ require true ]
     * @param  int $scId 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @param  string $discountType 折扣类型 [ require true ]
     * @param  string $shareType 共享类型 [ require true ]
     * @param  string $startTime 折扣开始时间 [ require true ]
     * @param  string $endTime 折扣结束时间 [ require true ]
     * @param  array $payload 折扣计算载荷 [ require true ]
     * @param  array $showInfo 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addProductNodeDiscount (string $name, string $group, int $nodeId, int $sort, int $scId, string $discountType, string $shareType, string $startTime, string $endTime, array $payload, array $showInfo = []) {
        return self::getClass()->addProductNodeDiscount([
            "name" => $name,
            "group" => $group,
            "nodeId" => $nodeId,
            "sort" => $sort,
            "scId" => $scId,
            "discountType" => $discountType,
            "shareType" => $shareType,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "payload" => $payload,
            "showInfo" => $showInfo,
        ]);
    }

    /**
     * 修改折扣信息
     *
     * @param  int $discountId 编辑的ID [Original type uint] [ require true ]
     * @param  array $showInfo 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editDiscount (int $discountId, array $showInfo = []) {
        return self::getClass()->editDiscount([
            "discountId" => $discountId,
            "showInfo" => $showInfo,
        ]);
    }

    /**
     * O1 分页方式, 使用limit和fromId进行分页
     *
     * @param  string $group 折扣分组 [ require true ]
     * @param  int $limit 限制值 [Original type uint] [ require true ]
     * @param  int $fromId 起始ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDiscountList (string $group, int $limit, int $fromId = 0) {
        return self::getClass()->getDiscountList([
            "group" => $group,
            "limit" => $limit,
            "fromId" => $fromId,
        ]);
    }

    /**
     * 软删除折扣
     *
     * @param  int $discountId 折扣ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteDiscount (int $discountId) {
        return self::getClass()->deleteDiscount([
            "discountId" => $discountId,
        ]);
    }

    /**
     * 恢复折扣
     *
     * @param  int $discountId 折扣ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function restoreDiscount (int $discountId) {
        return self::getClass()->restoreDiscount([
            "discountId" => $discountId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}