<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getChildAllAdditionNodeByParams(array $params)
 * @method addChildAdditionNodeByParams(array $params)
 * @method getNodeByParams(array $params)
 * @method editNodeByParams(array $params)
 * @method deleteNodeByParams(array $params)
 * @method restoreNodeByParams(array $params)
 * @method hideNodeByParams(array $params)
 * @method showNodeByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 树状模式获取下级子分类节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChildAllAdditionNode (int $nodeId, bool $includeHidden = false, bool $includeDelete = false) {
        return self::getClass()->getChildAllAdditionNode([
            "nodeId" => $nodeId,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
        ]);
    }

    /**
     * 添加下级子产品节点
     *
     * @param  int $parentNodeId 父节点 [Original type uint] [ require true ]
     * @param  bool $isHidden 是否为隐藏节点 [ require true ]
     * @param  string $name 节点名称 [ require true ]
     * @param  string $engName 节点英文名称 [ require true ]
     * @param  int $includeNum 包含子产品数量, 0或-1为不强制包含子产品 [Original type uint] [ require true ]
     * @param  string $fullName 完整名称 [ require true ]
     * @param  int $minPeople 最小人数 [Original type uint] [ require true ]
     * @param  int $maxPeople 最大人数 [Original type uint] [ require true ]
     * @param  string $realName 节点真实名称 [ require true ]
     * @param  int $sort 排序顺序 [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addChildAdditionNode (int $parentNodeId, string $name, string $engName, int $includeNum = -1, string $fullName = 'auto', int $minPeople = 1, int $maxPeople = 1, array $extend = [], int $sort = 0, string $realName = '', bool $isHidden = false) {
        return self::getClass()->addChildAdditionNode([
            "parentNodeId" => $parentNodeId,
            "name" => $name,
            "engName" => $engName,
            "includeNum" => $includeNum,
            "fullName" => $fullName,
            "minPeople" => $minPeople,
            "maxPeople" => $maxPeople,
            "extend" => $extend,
            "sort" => $sort,
            "realName" => $realName,
            "isHidden" => $isHidden,
        ]);
    }

    /**
     * 获取某个节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNode (int $nodeId, bool $includeHidden = false, bool $includeDelete = false) {
        return self::getClass()->getNode([
            "nodeId" => $nodeId,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
        ]);
    }

    /**
     * 修改节点
     *
     * @param  int $nodeId 父节点 [Original type uint] [ require true ]
     * @param  string $name 节点名称 [ require true ]
     * @param  string $engName 节点英文名称 [ require true ]
     * @param  int $includeNum 包含子产品数量, -1为不更改, 0为不包含子产品 [Original type uint] [ require true ]
     * @param  string $fullName 完整名称 [ require true ]
     * @param  int $minPeople 最小人数 [Original type uint] [ require true ]
     * @param  int $maxPeople 最大人数 [Original type uint] [ require true ]
     * @param  string $realName 节点真实名称 [ require true ]
     * @param  int $sort 排序顺序 [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editNode (int $nodeId, int $sort = 0, array $extend = [], string $name = '', string $engName = '', int $includeNum = -1, string $fullName = 'auto', int $minPeople = 1, int $maxPeople = 1, string $realName = '') {
        return self::getClass()->editNode([
            "nodeId" => $nodeId,
            "sort" => $sort,
            "extend" => $extend,
            "name" => $name,
            "engName" => $engName,
            "includeNum" => $includeNum,
            "fullName" => $fullName,
            "minPeople" => $minPeople,
            "maxPeople" => $maxPeople,
            "realName" => $realName,
        ]);
    }

    /**
     * 通常用于下线
     * 当有父级下线时, 其子项将会被影响成为下线状态(此下线状态不会在数据库中更改, 只是逻辑上的覆盖)
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteNode (int $nodeId) {
        return self::getClass()->deleteNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * 通常用于上线
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function restoreNode (int $nodeId) {
        return self::getClass()->restoreNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * 隐藏后该产品将不能直接获取到, 但是依旧应该可以售卖
     * 当有父级隐藏时, 其子项将会被影响成为隐藏状态(此下线状态不会在数据库中更改, 只是逻辑上的覆盖)
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function hideNode (int $nodeId) {
        return self::getClass()->hideNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * 是隐藏节点的相反操作
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function showNode (int $nodeId) {
        return self::getClass()->showNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}