<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreProductsByParams(array $params)
 * @method getOneStoreProductsByParams(array $params)
 * @method storeHaveProductByParams(array $params)
 * @method filterMustHaveProductsStoresByParams(array $params)
 * @method getStoreProductDetailByParams(array $params)
 * @method getStoreProductsDetailByParams(array $params)
 * @method getProductAllStoreByParams(array $params)
 */
class StoreProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品列表
     *
     * @param  array $storeIds 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  int $showLevel 显示级别 [Original type uint] [ require true ]
     * @param  array $nodeType 节点类型 [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @param  bool $hiddenNoPrice 隐藏没有价格的节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProducts (array $storeIds = [], int $showLevel = 1, array $nodeType = [0 => 'product'], bool $includeHidden = false, bool $includeDelete = false, bool $hiddenNoPrice = true) {
        return self::getClass()->getStoreProducts([
            "storeIds" => $storeIds,
            "showLevel" => $showLevel,
            "nodeType" => $nodeType,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
            "hiddenNoPrice" => $hiddenNoPrice,
        ]);
    }

    /**
     * 获取指定一家门店产品列表
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  int $showLevel 显示级别 [Original type uint] [ require true ]
     * @param  array $nodeType 节点类型 [ require true ]
     * @param  bool $showPrice 显示价格 [ require true ]
     * @param  bool $includeMustSelectPrice 包含必选产品的价格 [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @param  bool $hiddenNoPrice 隐藏没有价格的节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOneStoreProducts (int $storeId, int $showLevel = 1, array $nodeType = [0 => 'product'], bool $showPrice = false, bool $includeMustSelectPrice = false, bool $includeHidden = false, bool $includeDelete = false, bool $hiddenNoPrice = true) {
        return self::getClass()->getOneStoreProducts([
            "storeId" => $storeId,
            "showLevel" => $showLevel,
            "nodeType" => $nodeType,
            "showPrice" => $showPrice,
            "includeMustSelectPrice" => $includeMustSelectPrice,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
            "hiddenNoPrice" => $hiddenNoPrice,
        ]);
    }

    /**
     * 将返回拥有的产品ID
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  array $products 产品ID数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeHaveProduct (int $storeId, array $products = []) {
        return self::getClass()->storeHaveProduct([
            "storeId" => $storeId,
            "products" => $products,
        ]);
    }

    /**
     * 将返回拥有的门店ID
     *
     * @param  array $storeIds 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  array $products 产品ID数组 [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function filterMustHaveProductsStores (array $storeIds = [], array $products = []) {
        return self::getClass()->filterMustHaveProductsStores([
            "storeIds" => $storeIds,
            "products" => $products,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  int $nodeId 产品ID [Original type uint] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @param  bool $hiddenNoPrice 隐藏没有价格的节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductDetail (int $storeId, int $nodeId, bool $includeHidden = false, bool $includeDelete = false, bool $hiddenNoPrice = true) {
        return self::getClass()->getStoreProductDetail([
            "storeId" => $storeId,
            "nodeId" => $nodeId,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
            "hiddenNoPrice" => $hiddenNoPrice,
        ]);
    }

    /**
     * 单个查询时性能比单个低
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  array $nodeIds 产品ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @param  bool $hiddenNoPrice 隐藏没有价格的节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductsDetail (int $storeId, array $nodeIds, bool $includeHidden = false, bool $includeDelete = false, bool $hiddenNoPrice = true) {
        return self::getClass()->getStoreProductsDetail([
            "storeId" => $storeId,
            "nodeIds" => $nodeIds,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
            "hiddenNoPrice" => $hiddenNoPrice,
        ]);
    }

    /**
     * 获取某个产品绑定的所有门店
     *
     * @param  int $nodeId 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductAllStore (int $nodeId) {
        return self::getClass()->getProductAllStore([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'StoreProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}