<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductNodeInfoByParams(array $params)
 * @method getProductNodesInfoByParams(array $params)
 * @method getProductNodesInfoIncludeParentByParams(array $params)
 * @method getProductNodesFullNameByParams(array $params)
 * @method getProductAdditionNodeByParams(array $params)
 */
class ProductTool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 可以从 product, addition_node, addition 中查找
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductNodeInfo (int $nodeId, bool $includeHidden = false, bool $includeDelete = false) {
        return self::getClass()->getProductNodeInfo([
            "nodeId" => $nodeId,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
        ]);
    }

    /**
     * 获取多个产品的信息
     *
     * @param  array $nodeIds 节点ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductNodesInfo (array $nodeIds, bool $includeHidden = false, bool $includeDelete = false) {
        return self::getClass()->getProductNodesInfo([
            "nodeIds" => $nodeIds,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
        ]);
    }

    /**
     * 获取多个产品的信息, 并包含父级信息
     *
     * @param  array $nodeIds 节点ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @param  bool $treeMode 树状模式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductNodesInfoIncludeParent (array $nodeIds, bool $includeHidden = false, bool $includeDelete = false, bool $treeMode = false) {
        return self::getClass()->getProductNodesInfoIncludeParent([
            "nodeIds" => $nodeIds,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
            "treeMode" => $treeMode,
        ]);
    }

    /**
     * 获取多个产品的名称
     *
     * @param  array $nodeIds 节点ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductNodesFullName (array $nodeIds, bool $includeHidden = false, bool $includeDelete = false) {
        return self::getClass()->getProductNodesFullName([
            "nodeIds" => $nodeIds,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
        ]);
    }

    /**
     * 从节点查找指定的 additionNode 下属产品, 应该应用于海马体查找加修加印
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @param  string $type 节点类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductAdditionNode (int $nodeId, string $type) {
        return self::getClass()->getProductAdditionNode([
            "nodeId" => $nodeId,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductTool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}