<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-13 11:30:35
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductService
 * @method createByParams(array $params) 创建服务
 * @method updateByParams(array $params) 更新服务
 * @method deleteByParams(array $params) 删除服务
 * @method baseInfoByParams(array $params) 服务基本信息（包含删除）
 * @method batchGetGroupTypeByServiceIdsByParams(array $params) 批量通过服务ids获取对应服务组类型
 * @method batchChangeHiddenByParams(array $params) 批量显示/隐藏服务
 */
class ProductService {
    private static string $serviceName = "Product";

    private static string $className = "ProductService";

    /**
     * 创建服务
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 更新服务
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function update (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(array_merge($_params, ["id" => $id]));
    }

    /**
     * 删除服务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 服务基本信息（包含删除）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function baseInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->baseInfo(["id" => $id]);
    }

    /**
     * 批量通过服务ids获取对应服务组类型
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchGetGroupTypeByServiceIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetGroupTypeByServiceIds(["ids" => $ids]);
    }

    /**
     * 批量显示/隐藏服务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchChangeHidden (array $ids, bool $hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchChangeHidden(["ids" => $ids, "hidden" => $hidden]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}