<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-13 12:42:43
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method allByParams(array $params) 产品列表
 * @method listByParams(array $params) 产品列表分页
 * @method createByParams(array $params) 新增产品
 * @method detailByParams(array $params) 产品详情
 * @method baseInfoByParams(array $params) 产品基本信息（包含删除）
 * @method detailInStoreByParams(array $params) 门店产品详情(带价格)
 * @method updateByParams(array $params) 编辑产品
 * @method setCHiddenByParams(array $params) 设置预约端显示/隐藏
 * @method getDetailByIdsByParams(array $params) 批量获取产品基础信息详情
 * @method getDetailByIdsWithPriceAreasByParams(array $params) 批量获取产品详情(带价格区)
 * @method deleteByParams(array $params) 删除产品
 * @method upByParams(array $params) 上架一个产品
 * @method offByParams(array $params) 下架一个产品
 * @method batchUpByParams(array $params) 批量上架产品
 * @method batchOffByParams(array $params) 批量下架产品
 * @method batchChangeHiddenByParams(array $params) 批量显示/隐藏产品
 * @method getStoreProductsByParams(array $params) 获取门店下面的产品信息
 * @method getPriceInAreaByParams(array $params) 获取产品在某个价格区下面的价格
 * @method setDeadlineByParams(array $params) 设置预约截止时间
 * @method blacklistStoreIdsByParams(array $params) 产品禁用门店列表
 * @method multiBlacklistStoreIdsByParams(array $params) 产品禁用门店列表，多个交集
 * @method blacklistsByParams(array $params) 产品禁用门店列表
 * @method addStoreToBlacklistByParams(array $params) 产品禁用门店, 返回更新后的禁用门店列表
 * @method batchStoreAddProductToBlacklistByParams(array $params) 批量对门店操作黑名单(新增,移除,重置)
 * @method getStoreListByHaveBlacklistByParams(array $params) 获取门店禁用产品数量&amp;可拍产品数量
 * @method getBlacklistByStoreIdByParams(array $params) 根据门店查询禁用产品列表
 * @method getBlacklistByStoreIdsByParams(array $params) 批量根据门店查询禁用产品列表
 * @method removeStoreFromBlacklistByParams(array $params) 移除黑名单中的门店, 返回更新后的禁用门店列表
 * @method getServiceByIdsByParams(array $params) 批量获取服务详情
 * @method getNameByParams(array $params) 批量获取名称
 * @method getFullNameByParams(array $params) 批量获取全称
 * @method getServiceIdsByTypeOrProductIdsByParams(array $params) 批量获取服务ids
 * @method getServiceFullNameByParams(array $params) 批量获取服务全称
 * @method canSendImageToCloudServiceByIdsByParams(array $params) 获取云端传图类服务
 * @method getProductTreeByIdsByParams(array $params) 根据产品ids获取产品树
 * @method getProductTreeByModuleByParams(array $params) 获取根类目产品树
 * @method getPhotographicNumByParams(array $params) 获取可上传摄影数量
 * @method getStoreProductTreeByParams(array $params) 获取门店产品树
 * @method getProductsByStoreIdCategoryIdsByParams(array $params) 获取门店某些类目下所有产品
 * @method getProductsByStoreIdCategoryIdByParams(array $params) 获取门店某个类目下所有产品
 * @method getStoreAllProductByParams(array $params) 获取门店所有产品, 适当传参, 带上类目和服务会慢
 * @method haveSameProductsAndServicesStoreByParams(array $params) 筛选出同有某些产品和升级服务的一些门店
 * @method haveSameProductProductStoreByParams(array $params) 筛选出同有某个产品的一些门店
 * @method haveSameProductProductStoreIntersectByParams(array $params) 筛选出同有某个产品的一些门店(优化版本)
 * @method getStoreProductUseGivenProductByParams(array $params) 筛选出门店可售卖产品在给出的产品中
 * @method haveSomeProductStoreByParams(array $params) 筛选出同有某些产品中部分的一些门店
 * @method getProductsInStoreByParams(array $params) 获取门店多个产品详情
 * @method getProductInStoreByParams(array $params) 查询门店的一个产品（含在该门店的价格）
 * @method serviceGroupsByParams(array $params) 批量获取全部服务组
 * @method serviceLabelsByParams(array $params) 批量获取全部服务项
 * @method addServiceGroupByParams(array $params) 创建一个服务组
 * @method editServiceGroupByParams(array $params) 编辑升级服务组
 * @method addServiceLabelByParams(array $params) 创建一个服务项（存在同名则返回同名的那个）
 * @method getProductAndServiceByStoreIdsByParams(array $params) 批量获取多个门店产品服务信息
 * @method updateExtendByParams(array $params) 更新产品展示信息
 * @method getCategoryIdsByStoreIdsByParams(array $params) 获取门店下的类目ids
 * @method getServiceIdsByProductIdsByParams(array $params) 根据产品ID获取必选服务ID
 * @method syncProductTagsByParams(array $params) 同步产品上的标签关联
 * @method getProductsWithStoresByParams(array $params) 获取产品可拍摄门店
 * @method getProductsWithStoresByCategoryByParams(array $params) 获取产品组下产品可拍摄门店
 * @method addStoreToProductDefaultBlacklistByParams(array $params) 新店自动加入指定产品黑名单
 * @method clearCacheTagByParams(array $params) 清除指定tag缓存
 * @method compareProductByParams(array $params) 比较产品信息
 * @method compareServiceByParams(array $params) 比较服务信息
 */
class Product {
    private static string $serviceName = "Product";

    private static string $className = "Product";

    /**
     * 产品列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function all (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all($_params);
    }

    /**
     * 产品列表分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }

    /**
     * 新增产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 产品详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 产品基本信息（包含删除）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function baseInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->baseInfo(["id" => $id]);
    }

    /**
     * 门店产品详情(带价格)
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function detailInStore (int $id, int $store_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailInStore(array_merge($_params, ["id" => $id, "store_id" => $store_id]));
    }

    /**
     * 编辑产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function update (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(array_merge($_params, ["id" => $id]));
    }

    /**
     * 设置预约端显示/隐藏
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function setCHidden (int $id, bool $hiddenInClient = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCHidden(["id" => $id, "hiddenInClient" => $hiddenInClient]);
    }

    /**
     * 批量获取产品基础信息详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getDetailByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetailByIds(["ids" => $ids]);
    }

    /**
     * 批量获取产品详情(带价格区)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getDetailByIdsWithPriceAreas (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetailByIdsWithPriceAreas(["ids" => $ids]);
    }

    /**
     * 删除产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 上架一个产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function up (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->up(["id" => $id]);
    }

    /**
     * 下架一个产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function off (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->off(["id" => $id]);
    }

    /**
     * 批量上架产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchUp (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUp(["ids" => $ids]);
    }

    /**
     * 批量下架产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchOff (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchOff(["ids" => $ids]);
    }

    /**
     * 批量显示/隐藏产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchChangeHidden (array $ids, bool $hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchChangeHidden(["ids" => $ids, "hidden" => $hidden]);
    }

    /**
     * 获取门店下面的产品信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStoreProducts (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProducts($_params);
    }

    /**
     * 获取产品在某个价格区下面的价格
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getPriceInArea (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPriceInArea(array_merge($_params, ["id" => $id]));
    }

    /**
     * 设置预约截止时间
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function setDeadline (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setDeadline(array_merge($_params, ["id" => $id]));
    }

    /**
     * 产品禁用门店列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function blacklistStoreIds (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->blacklistStoreIds(["id" => $id]);
    }

    /**
     * 产品禁用门店列表，多个交集
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function multiBlacklistStoreIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->multiBlacklistStoreIds(["ids" => $ids]);
    }

    /**
     * 产品禁用门店列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function blacklists (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->blacklists(["id" => $id]);
    }

    /**
     * 产品禁用门店, 返回更新后的禁用门店列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addStoreToBlacklist (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoreToBlacklist(array_merge($_params, ["id" => $id]));
    }

    /**
     * 批量对门店操作黑名单(新增,移除,重置)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchStoreAddProductToBlacklist (string $handle_type, array $store_ids, array $ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchStoreAddProductToBlacklist(["handle_type" => $handle_type, "store_ids" => $store_ids, "ids" => $ids]);
    }

    /**
     * 获取门店禁用产品数量&amp;可拍产品数量
     * @return  mixed
    */
    public static function getStoreListByHaveBlacklist () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByHaveBlacklist();
    }

    /**
     * 根据门店查询禁用产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getBlacklistByStoreId (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBlacklistByStoreId(["store_id" => $store_id]);
    }

    /**
     * 批量根据门店查询禁用产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getBlacklistByStoreIds (array $store_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBlacklistByStoreIds(["store_ids" => $store_ids]);
    }

    /**
     * 移除黑名单中的门店, 返回更新后的禁用门店列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function removeStoreFromBlacklist (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeStoreFromBlacklist(array_merge($_params, ["id" => $id]));
    }

    /**
     * 批量获取服务详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getServiceByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceByIds(["ids" => $ids]);
    }

    /**
     * 批量获取名称
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getName(["ids" => $ids]);
    }

    /**
     * 批量获取全称
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getFullName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFullName(["ids" => $ids]);
    }

    /**
     * 批量获取服务ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getServiceIdsByTypeOrProductIds (string $type = 'cloud_send_image', array $product_ids = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceIdsByTypeOrProductIds(["type" => $type, "product_ids" => $product_ids]);
    }

    /**
     * 批量获取服务全称
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getServiceFullName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceFullName(["ids" => $ids]);
    }

    /**
     * 获取云端传图类服务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function canSendImageToCloudServiceByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canSendImageToCloudServiceByIds(["ids" => $ids]);
    }

    /**
     * 根据产品ids获取产品树
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductTreeByIds (array $product_ids, string $status = 'all', int $show_level = 0, bool $c_hidden = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByIds(["product_ids" => $product_ids, "status" => $status, "show_level" => $show_level, "c_hidden" => $c_hidden]);
    }

    /**
     * 获取根类目产品树
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getProductTreeByModule (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByModule($_params);
    }

    /**
     * 获取可上传摄影数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPhotographicNum (int $pid, int $sid = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographicNum(["pid" => $pid, "sid" => $sid]);
    }

    /**
     * 获取门店产品树
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreProductTree (int $store_id, int $show_level = 1, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $reject_no_products_category = false, bool $with_services = true, string $order_by_sort = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProductTree(["store_id" => $store_id, "show_level" => $show_level, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "reject_no_products_category" => $reject_no_products_category, "with_services" => $with_services, "order_by_sort" => $order_by_sort]);
    }

    /**
     * 获取门店某些类目下所有产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductsByStoreIdCategoryIds (int $store_id, array $category_ids, string $module = 'himo_blue', string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStoreIdCategoryIds(["store_id" => $store_id, "category_ids" => $category_ids, "module" => $module, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_category" => $with_category, "with_services" => $with_services]);
    }

    /**
     * 获取门店某个类目下所有产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsByStoreIdCategoryId (int $store_id, int $category_id, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStoreIdCategoryId(["store_id" => $store_id, "category_id" => $category_id, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_category" => $with_category, "with_services" => $with_services]);
    }

    /**
     * 获取门店所有产品, 适当传参, 带上类目和服务会慢
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStoreAllProduct (int $store_id, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true, bool $is_style = null, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreAllProduct(array_merge($_params, ["store_id" => $store_id, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_category" => $with_category, "with_services" => $with_services, "is_style" => $is_style]));
    }

    /**
     * 筛选出同有某些产品和升级服务的一些门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function haveSameProductsAndServicesStore (array $store_ids = [], array $products = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSameProductsAndServicesStore(["store_ids" => $store_ids, "products" => $products]);
    }

    /**
     * 筛选出同有某个产品的一些门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function haveSameProductProductStore (array $store_ids = [], array $product_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSameProductProductStore(["store_ids" => $store_ids, "product_ids" => $product_ids]);
    }

    /**
     * 筛选出同有某个产品的一些门店(优化版本)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function haveSameProductProductStoreIntersect (array $storeIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSameProductProductStoreIntersect(["storeIds" => $storeIds, "productIds" => $productIds]);
    }

    /**
     * 筛选出门店可售卖产品在给出的产品中
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreProductUseGivenProduct (array $storeIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProductUseGivenProduct(["storeIds" => $storeIds, "productIds" => $productIds]);
    }

    /**
     * 筛选出同有某些产品中部分的一些门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function haveSomeProductStore (array $store_ids = [], array $product_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSomeProductStore(["store_ids" => $store_ids, "product_ids" => $product_ids]);
    }

    /**
     * 获取门店多个产品详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsInStore (array $product_ids, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInStore(["product_ids" => $product_ids, "store_id" => $store_id]);
    }

    /**
     * 查询门店的一个产品（含在该门店的价格）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductInStore (int $product_id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInStore(["product_id" => $product_id, "store_id" => $store_id]);
    }

    /**
     * 批量获取全部服务组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function serviceGroups (array $ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceGroups(["ids" => $ids]);
    }

    /**
     * 批量获取全部服务项
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function serviceLabels (array $ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceLabels(["ids" => $ids]);
    }

    /**
     * 创建一个服务组
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addServiceGroup (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceGroup($_params);
    }

    /**
     * 编辑升级服务组
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editServiceGroup (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editServiceGroup($_params);
    }

    /**
     * 创建一个服务项（存在同名则返回同名的那个）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addServiceLabel (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceLabel(["name" => $name]);
    }

    /**
     * 批量获取多个门店产品服务信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductAndServiceByStoreIds (array $store_ids, bool $hidden_no_price = false, string $status = 'on') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductAndServiceByStoreIds(["store_ids" => $store_ids, "hidden_no_price" => $hidden_no_price, "status" => $status]);
    }

    /**
     * 更新产品展示信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateExtend (int $id, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateExtend(["id" => $id, "extend" => $extend]);
    }

    /**
     * 获取门店下的类目ids
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCategoryIdsByStoreIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryIdsByStoreIds($_params);
    }

    /**
     * 根据产品ID获取必选服务ID
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getServiceIdsByProductIds (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceIdsByProductIds($_params);
    }

    /**
     * 同步产品上的标签关联
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function syncProductTags (int $productId, array $tagIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncProductTags(["productId" => $productId, "tagIds" => $tagIds]);
    }

    /**
     * 获取产品可拍摄门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsWithStores (array $productIds, array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsWithStores(["productIds" => $productIds, "storeIds" => $storeIds]);
    }

    /**
     * 获取产品组下产品可拍摄门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsWithStoresByCategory (int $categoryId, array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsWithStoresByCategory(["categoryId" => $categoryId, "storeIds" => $storeIds]);
    }

    /**
     * 新店自动加入指定产品黑名单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addStoreToProductDefaultBlacklist (int $priceAreaId, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoreToProductDefaultBlacklist(["priceAreaId" => $priceAreaId, "storeIds" => $storeIds]);
    }

    /**
     * 清除指定tag缓存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function clearCacheTag (string $tagName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCacheTag(["tagName" => $tagName]);
    }

    /**
     * 比较产品信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function compareProduct (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->compareProduct($_params);
    }

    /**
     * 比较服务信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function compareService (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->compareService($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}