<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-18 16:50:26
 */
namespace Mainto\Bridge\Invokes\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Stock
 * @method allocateByParams(array $params) 调配
 * @method getStocksByParams(array $params) 库存查询-分页
 * @method getStockProductsByParams(array $params) 获取库存记录列表-分页
 * @method listForStockProductsByParams(array $params) 获取库存记录列表-不分页
 * @method getStockProductsWithTrashedByParams(array $params) 获取库存记录列表-不分页
 * @method infoByParams(array $params) 获取库存记录详情
 * @method getStockProductByParams(array $params) 获取库存详情信息
 * @method stockLockByParams(array $params) 锁定库存
 * @method releaseStockLockByParams(array $params) 释放锁定库存
 */
class Stock {
    private static string $serviceName = "Preferential";

    private static string $className = "Stock";

    /**
     * 调配
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function allocate (int $operator, int $stockStoreId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allocate(["operator" => $operator, "stockStoreId" => $stockStoreId]);
    }

    /**
     * 库存查询-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStocks (bool $with_cover_info = false, bool $filter_zero_stock = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStocks(["with_cover_info" => $with_cover_info, "filter_zero_stock" => $filter_zero_stock]);
    }

    /**
     * 获取库存记录列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStockProducts (bool $with_card_info = false, int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProducts(["with_card_info" => $with_card_info, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * 获取库存记录列表-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listForStockProducts (bool $withCardInfo = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listForStockProducts(["withCardInfo" => $withCardInfo]);
    }

    /**
     * 获取库存记录列表-不分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStockProductsWithTrashed (array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProductsWithTrashed(["cardIds" => $cardIds]);
    }

    /**
     * 获取库存记录详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function info (bool $with_card_info = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["with_card_info" => $with_card_info]);
    }

    /**
     * 获取库存详情信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStockProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockProduct([]);
    }

    /**
     * 锁定库存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function stockLock (int $storeId, array $cardIds, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockLock(["storeId" => $storeId, "cardIds" => $cardIds, "operator" => $operator]);
    }

    /**
     * 释放锁定库存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function releaseStockLock (int $storeId, array $cardIds, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->releaseStockLock(["storeId" => $storeId, "cardIds" => $cardIds, "operator" => $operator]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}