<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-27 11:12:57
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GiftCardOrder
 * @method managerCreateByParams(array $params) 管理端售卖礼品卡
 * @method userCreateByParams(array $params) 用户购买礼品卡【线上】
 * @method afterPayByParams(array $params) 礼品卡订单支付【线上支付|线下拉卡拉支付】
 * @method prepaidCreateByParams(array $params) 创建礼品卡订单【未支付订单】- 线上
 * @method getPayTypesByParams(array $params) 礼品卡订单支付类型
 * @method getListByParams(array $params) 获取列表
 * @method getListByPageByParams(array $params) 获取列表-分页
 * @method getInfoByParams(array $params) 获取详情
 * @method getInfoByNoByParams(array $params) 根据订单号获取详情
 * @method updateInvoiceIdByParams(array $params) updateInvoiceId
 * @method changePayTypeByParams(array $params) 修改支付方式
 */
class GiftCardOrder {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCardOrder";

    /**
     * 管理端售卖礼品卡
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function managerCreate (string $phone, int $user_id, string $user_name, float $ori_money, int $create_by, int $is_attach_other_coupon, int $is_attach_repair_coupon) {
        return RpcClass::getClass(self::$serviceName, self::$className)->managerCreate(["phone" => $phone, "user_id" => $user_id, "user_name" => $user_name, "ori_money" => $ori_money, "create_by" => $create_by, "is_attach_other_coupon" => $is_attach_other_coupon, "is_attach_repair_coupon" => $is_attach_repair_coupon]);
    }

    /**
     * 用户购买礼品卡【线上】
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function userCreate (string $phone, int $user_id, float $pay_money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userCreate(["phone" => $phone, "user_id" => $user_id, "pay_money" => $pay_money]);
    }

    /**
     * 礼品卡订单支付【线上支付|线下拉卡拉支付】
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function afterPay (int $order_id, string $pay_type, string $payment_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterPay(["order_id" => $order_id, "pay_type" => $pay_type, "payment_no" => $payment_no]);
    }

    /**
     * 创建礼品卡订单【未支付订单】- 线上
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function prepaidCreate (string $phone, int $user_id, int $store_id, int $create_by, string $user_name, float $ori_money, \Mainto\Bridge\Structs\Preferential\GiftCard\GiftCardOrder\PrepaidCreateParamsExtend $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->prepaidCreate(["phone" => $phone, "user_id" => $user_id, "store_id" => $store_id, "create_by" => $create_by, "user_name" => $user_name, "ori_money" => $ori_money, "extend" => $extend]);
    }

    /**
     * 礼品卡订单支付类型
     * @return  array
    */
    public static function getPayTypes () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayTypes();
    }

    /**
     * 获取列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList([]);
    }

    /**
     * 获取列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPage(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * 获取详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id]);
    }

    /**
     * 根据订单号获取详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInfoByNo (string $order_no) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoByNo(["order_no" => $order_no]);
    }

    /**
     * updateInvoiceId
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateInvoiceId (array $order_nums, int $invoice_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateInvoiceId(["order_nums" => $order_nums, "invoice_id" => $invoice_id]);
    }

    /**
     * 修改支付方式
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changePayType (int $id, string $pay_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType(["id" => $id, "pay_type" => $pay_type]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}