<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-06 10:33:17
 */
namespace Mainto\Bridge\Invokes\Preferential\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GiftCard
 * @method createRefundCardByParams(array $params) 退款生成礼品卡(一张)
 * @method generateAnniversaryCardByParams(array $params) 生成伙伴周年庆卡(一张)
 * @method getCardInfoByParams(array $params) 获取详情
 * @method getCardListByParams(array $params) 获取列表
 * @method getCardListByPageByParams(array $params) 获取列表-分页
 * @method getUserBalanceByParams(array $params) 获取用户余额
 * @method getUserAttachBalanceByParams(array $params) 获取用户的余额
 * @method getUserValidDateByParams(array $params) 获取用户礼品卡有效期
 * @method batchChargeByParams(array $params) 批量充值
 * @method chargeByParams(array $params) 充值
 * @method bindCardByParams(array $params) 绑定礼品卡-转出礼品卡失败重新绑回赠送人账户
 * @method abolishCardByParams(array $params) 作废礼品码
 * @method transCardToWXCardByParams(array $params) 转出礼品卡到微信卡包
 * @method bindAndRemoveWXCardByParams(array $params) 绑定微信卡包礼品卡
 * @method getUserGiftCardPaymentLogsByParams(array $params) 查询用户礼品卡消费记录，请参考：App\Interfaces\GiftCard\Controllers\GiftCardPaymentController
 * @method delayByParams(array $params) 礼品码延期
 * @method withdrawByParams(array $params) 礼品卡提现
 * @method batchUpdateAttachInfoByParams(array $params) 更新礼品卡是否可叠加信息
 */
class GiftCard {
    private static string $serviceName = "Preferential";

    private static string $className = "GiftCard\\GiftCard";

    /**
     * 退款生成礼品卡(一张)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createRefundCard (int $user_id, float $money, int $out_refund_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRefundCard(["user_id" => $user_id, "money" => $money, "out_refund_id" => $out_refund_id]);
    }

    /**
     * 生成伙伴周年庆卡(一张)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function generateAnniversaryCard (int $cover_id, int $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->generateAnniversaryCard(["cover_id" => $cover_id, "money" => $money]);
    }

    /**
     * 获取详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCardInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardInfo([]);
    }

    /**
     * 获取列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCardList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardList([]);
    }

    /**
     * 获取列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCardListByPage (int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCardListByPage(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * 获取用户余额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  float
    */
    public static function getUserBalance (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserBalance(["user_id" => $user_id]);
    }

    /**
     * 获取用户的余额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserAttachBalance (int $userId, array $attachInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserAttachBalance(["userId" => $userId, "attachInfo" => $attachInfo]);
    }

    /**
     * 获取用户礼品卡有效期
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getUserValidDate (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserValidDate(["user_id" => $user_id]);
    }

    /**
     * 批量充值
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchCharge (int $userId, array $cardIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCharge(["userId" => $userId, "cardIds" => $cardIds]);
    }

    /**
     * 充值
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function charge (int $user_id, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->charge(["user_id" => $user_id, "code" => $code]);
    }

    /**
     * 绑定礼品卡-转出礼品卡失败重新绑回赠送人账户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bindCard (int $user_id, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindCard(["user_id" => $user_id, "code" => $code]);
    }

    /**
     * 作废礼品码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function abolishCard () {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishCard([]);
    }

    /**
     * 转出礼品卡到微信卡包
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function transCardToWXCard (string $scene, int $user_id, string $open_id, string $cardId, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transCardToWXCard(["scene" => $scene, "user_id" => $user_id, "open_id" => $open_id, "cardId" => $cardId, "code" => $code]);
    }

    /**
     * 绑定微信卡包礼品卡
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bindAndRemoveWXCard (string $scene, int $user_id, string $cardId, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindAndRemoveWXCard(["scene" => $scene, "user_id" => $user_id, "cardId" => $cardId, "code" => $code]);
    }

    /**
     * 查询用户礼品卡消费记录，请参考：App\Interfaces\GiftCard\Controllers\GiftCardPaymentController
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getUserGiftCardPaymentLogs (int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserGiftCardPaymentLogs(["user_id" => $user_id]);
    }

    /**
     * 礼品码延期
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delay (array $codes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay(["codes" => $codes]);
    }

    /**
     * 礼品卡提现
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function withdraw (int $card_id, float $money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->withdraw(["card_id" => $card_id, "money" => $money]);
    }

    /**
     * 更新礼品卡是否可叠加信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function batchUpdateAttachInfo (array $ids, int $isAttach) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateAttachInfo(["ids" => $ids, "isAttach" => $isAttach]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}