<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-05 18:01:52
 */
namespace Mainto\Bridge\Invokes\Preferential\Coupon;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class InteriorCoupon
 * @method getCouponDiscountPriceByParams(array $params) 获取优惠码折扣
 * @method listByParams(array $params) 获取列表
 * @method getCouponsByParams(array $params) 获取列表-分页
 * @method getInfoByParams(array $params) 获取详情
 * @method abolishByParams(array $params) 内部折扣码作废
 * @method delayByParams(array $params) 优惠券延期
 * @method useByParams(array $params) 使用开单折扣码
 * @method refundByParams(array $params) 撤销核销折扣码
 * @method interiorCouponRefundByParams(array $params) 退款核销折扣码
 * @method updateTransferInfoByParams(array $params) 更新适用订单【转门店】
 * @method retakeByParams(array $params) 重拍
 */
class InteriorCoupon {
    private static string $serviceName = "Preferential";

    private static string $className = "Coupon\\InteriorCoupon";

    /**
     * 获取优惠码折扣
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  float
    */
    public static function getCouponDiscountPrice (string $uuid, bool $verify_usability = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponDiscountPrice(["uuid" => $uuid, "verify_usability" => $verify_usability]);
    }

    /**
     * 获取列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list([]);
    }

    /**
     * 获取列表-分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCoupons (int $page = 1, int $page_size = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoupons(["page" => $page, "page_size" => $page_size]);
    }

    /**
     * 获取详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["id" => $id]);
    }

    /**
     * 内部折扣码作废
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function abolish (array $uuids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolish(["uuids" => $uuids]);
    }

    /**
     * 优惠券延期
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delay (array $uuids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delay(["uuids" => $uuids]);
    }

    /**
     * 使用开单折扣码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function use (string $uuid, float $money, int $store_id, int $order_diff_id, int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->use(["uuid" => $uuid, "money" => $money, "store_id" => $store_id, "order_diff_id" => $order_diff_id, "order_id" => $order_id]);
    }

    /**
     * 撤销核销折扣码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function refund (int $orderDiffId, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refund(["orderDiffId" => $orderDiffId, "uuid" => $uuid]);
    }

    /**
     * 退款核销折扣码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function interiorCouponRefund (string $uuid, int $orderDiffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->interiorCouponRefund(["uuid" => $uuid, "orderDiffId" => $orderDiffId]);
    }

    /**
     * 更新适用订单【转门店】
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateTransferInfo (int $id, int $newOrderId, int $newOrderDiffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTransferInfo(["id" => $id, "newOrderId" => $newOrderId, "newOrderDiffId" => $newOrderDiffId]);
    }

    /**
     * 重拍
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function retake (int $id, int $newOrderId, int $newOrderDiffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retake(["id" => $id, "newOrderId" => $newOrderId, "newOrderDiffId" => $newOrderDiffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}